% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPAGRM.R
\name{GRAB.SPAGRM}
\alias{GRAB.SPAGRM}
\title{Instruction of SPAGRM method}
\usage{
GRAB.SPAGRM()
}
\description{
SPAGRM is a scalable and accurate framework for retrospective association tests.
It treats genetic loci as random vectors and uses a precise approximation of their
joint distribution. This approach enables SPAGRM to handle any type of complex trait,
including longitudinal and unbalanced phenotypes. SPAGRM extends SPACox to support
sample relatedness.
}
\details{
See \code{\link{SPAGRM.NullModel}} for detailed instructions
on preparing a SPAGRM_NULL_Model object required for GRAB.Marker().

\strong{Additional Control Parameters for GRAB.Marker()}:
\itemize{
\item \code{zeta} (numeric, default: 0): SPA moment approximation parameter.
\item \code{tol} (numeric, default: 1e-5): Numerical tolerance for SPA convergence.
}

\strong{Marker-level results} (\code{OutputFile}) columns:
\describe{
\item{Marker}{Marker identifier (rsID or CHR:POS:REF:ALT).}
\item{Info}{Marker information in format CHR:POS:REF:ALT.}
\item{AltFreq}{Alternative allele frequency in the sample.}
\item{AltCounts}{Total count of alternative alleles.}
\item{MissingRate}{Proportion of missing genotypes.}
\item{zScore}{Z-score from the score test.}
\item{Pvalue}{P-value from the score test.}
\item{hwepval}{Hardy-Weinberg equilibrium p-value.}
}
}
\examples{
ResidMatFile <- system.file("extdata", "ResidMat.txt", package = "GRAB")
SparseGRMFile <- system.file("extdata", "SparseGRM.txt", package = "GRAB")
PairwiseIBDFile <- system.file("extdata", "PairwiseIBD.txt", package = "GRAB")
GenoFile <- system.file("extdata", "simuPLINK.bed", package = "GRAB")
OutputFile <- file.path(tempdir(), "resultSPAGRM.txt")

# Step 2a: pre-calculate genotype distributions
obj.SPAGRM <- SPAGRM.NullModel(
  ResidMatFile = ResidMatFile,
  SparseGRMFile = SparseGRMFile,
  PairwiseIBDFile = PairwiseIBDFile,
  control = list(ControlOutlier = FALSE)
)

# Step 2b: perform association tests
GRAB.Marker(obj.SPAGRM, GenoFile, OutputFile)

head(data.table::fread(OutputFile))

}
\references{
Xu et al. (2025). SPAGRM: effectively controlling for sample relatedness in large-scale
genome-wide association studies of longitudinal traits. \doi{10.1038/s41467-025-56669-1}
}
