\name{GMMinit-package}
\alias{GMMinit-package}
\alias{GMMinit}
\docType{package}
\title{Optimal Initial Value for Gaussian Mixture Model}
\description{
Provides an approach to compute an optimal initial value 
for the Expectation-Maximization (EM) algorithm when fitting a Gaussian Mixture Model (GMM). 
This ensures better convergence and improved model fitting.
}
\details{
\tabular{ll}{
Package: \tab GMMinit\cr
Type: \tab Package\cr
Version: \tab 1.0.0\cr
Date: \tab 2026-01-20\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab no\cr
}
This package includes functions for:
\itemize{
  \item Computing an optimal initialization for GMM.
  \item Running the Expectation-Maximization (EM) algorithm.
}

}
\author{
Jing Li \email{jli178@crimson.ua.edu} [aut, cre] \cr
Yana Melnykov \email{ymelnykov@ua.edu} [aut]
}
\references{
Michael, S., & Melnykov, V. (2016). An effective strategy for initializing the EM algorithm in finite mixture models. 
\emph{Advances in Data Analysis and Classification}, 10(4), 563–583. 


Fraley, C., & Raftery, A. E. (2002). Model-based clustering, discriminant analysis, and density estimation. 
\emph{Journal of the American Statistical Association}, 97(458), 611-631. [mclust]

Hartigan, J. A., & Wong, M. A. (1979). Algorithm AS 136: A k-means clustering algorithm. 
\emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 28(1), 100-108. [k-means]

Dempster, A. P., Laird, N. M., & Rubin, D. B. (1977). Maximum likelihood from incomplete data via the EM algorithm. 
\emph{Journal of the Royal Statistical Society: Series B (Methodological)}, 39(1), 1-22. [EM Algorithm]

Celeux, G., & Govaert, G. (1992). A classification EM algorithm for clustering and two stochastic versions. 
\emph{Computational Statistics & Data Analysis}, 14(3), 315-332. [CEM & SEM]

McLachlan, G., & Peel, D. (2000). Finite Mixture Models. John Wiley & Sons. [General EM & GMM]

Biernacki, C., Celeux, G., & Govaert, G. (2003). Choosing starting values for the EM algorithm in Gaussian mixture models. 
\emph{Computational Statistics & Data Analysis}, 41(3-4), 561-575. [Alternative EM Initializations]
}


\keyword{package}
\seealso{
  \code{\link{getInit}}, 
  \code{\link{runGMM}}, 
  \code{\link{BestGMM}}, 
  \code{\link{getBestInit}},
  \code{\link{runEM}}
}

\examples{
# Generate sample data
set.seed(123)
data <- matrix(rnorm(100 * 2), ncol = 2)

# Compute optimal initialization
library(GMMinit)
init <- getInit(data, k = 2, method = "Random")
print(init)
}
