\name{BestGMM}
\alias{BestGMM}
\title{Select the Best Gaussian Mixture Model (GMM) Based on BIC}
\description{
Identifies and returns the best Gaussian Mixture Model (GMM) result from multiple 
initialization strategies by selecting the model with the lowest Bayesian Information
Criterion (BIC).
}
\usage{
BestGMM(all_result)
}
\arguments{
\item{all_result}{
    A named list of GMM model results produced by different initialization 
    methods. Each element is typically an output from \code{runGMM()} or a similar 
    GMM-fitting function. Failed initializations may appear as \code{NULL}.
  }

}

\value{
A list describing the selected best GMM model. The returned list contains:

  \itemize{
    \item \code{best}  
      The GMM model object corresponding to the lowest BIC.  
      This object typically contains:
      \itemize{
        \item \code{BIC} The model's BIC value.
        \item \code{param} A list of estimated GMM parameters:
          \itemize{
            \item \code{pi_k} Mixing proportions.
            \item \code{mu} Cluster mean matrix.
            \item \code{sigma} Covariance matrices.
          }
        \item \code{cluster} Cluster assignments for each observation.
        \item \code{Z} Posterior probability matrix of cluster memberships.
      }

    \item \code{initial_method}  
      A character string identifying which initialization method produced 
      the best model.

    \item \code{BIC}  
      A numeric vector of BIC values for all initialization methods,
      with \code{NA} for failed fits.
  }

If all candidate models fail, \code{best} and \code{initial_method} 
are returned as \code{NULL}.
}



\details{
The \code{BestGMM} takes the output from \code{runGMM()} and selects the best model 
by identifying the initialization method that results in the lowest BIC. 

}
\seealso{
\code{\link{runGMM}}, \code{\link{runEM}}
}
\examples{
# Generate sample data
set.seed(123)
data <- matrix(rnorm(100 * 2), ncol = 2)

# Run GMM clustering with multiple initialization methods
results <- runGMM(data, k = 2)

# Select the best GMM based on BIC
best_model <- BestGMM(results)

# Print the best model
print(best_model)

}
\keyword{GMM}
\keyword{clustering}
\keyword{model selection}
