% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.trait.values.R
\name{sim.gradient}
\alias{sim.gradient}
\title{Simulate an environmental gradient}
\usage{
sim.gradient(strata, depth = 2, cycles = 2)
}
\arguments{
\item{strata}{Number of stratigraphic intervals.}

\item{depth}{Maximum water depth.}

\item{cycles}{Number of cycles (e.g. transgressions and regressions).}
}
\value{
vector of sampled water depths.
}
\description{
Function returns a vector using the sine wave function \eqn{y = depth*sin(cycles*pi*(x-1/4))}
for a given set of intervals.
This vector can be used as a gradient to simulate fossils under an environment-dependent model of fossil recovery using the
function \code{sim.fossils.environment}.
}
\examples{
strata = 100
wd = sim.gradient(strata)
plot(wd, type="l")
}
\seealso{
\code{\link{sim.fossils.environment}}
}
\keyword{fossil}
\keyword{non-uniform}
\keyword{preservation}
