% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_stand_methods.R
\name{plot.fe_stand}
\alias{plot.fe_stand}
\title{Plot an \strong{fe_stand} Object}
\usage{
\method{plot}{fe_stand}(x, tree_filter = TRUE, ...)
}
\arguments{
\item{x}{an \code{fe_stand} object}

\item{tree_filter}{A \code{data-masking} expression that applies to the
data.frame \code{x$trees}. It must return a logical value, and is defined
in terms of the variables in \code{x$trees}. In this function, it is used
internally in order to define the cohort of trees which is to be evaluated
by this function (within a call to \code{dplyr::filter()}). While many
meaningful filterings are conceivable, distinctions between total stand,
removal stand, and remaining stand are the most probable applications.
Defaults to \code{TRUE}, i.e. all trees are included. See examples.}

\item{...}{additional arguments, not used in \code{plot.fe_stand}}
}
\value{
A plot (ggplot2) of the diameter distribution
}
\description{
Diameter distributions in number of trees per ha, one diagrame by year of
survey, tree cohort to be displayed can be filtered.
}
\details{
The diagram(s) are made with \code{ggplot2::geom_bar}, the colours for the
species, the number and width of the diameter bins correspond to the default
settings in ggplot.
}
\examples{
# display scientific species names in all examples
old_opt <- getOption("fe_spec_lang") # store current user sertting
options(fe_spec_lang = "sci") # display scientific names

# mixed mountain forest - all trees
mm_forest_1_fe_stand_spatial |> plot()
# ... remaining trees only
mm_forest_1_fe_stand_spatial |> plot(tree_filter = !removal)
# ... removal only
mm_forest_1_fe_stand_spatial |> plot(tree_filter = removal)
# ... all trees with dbh > 30 cm
mm_forest_1_fe_stand_spatial |> plot(tree_filter = dbh_cm > 20)

# other example stands
selection_forest_1_fe_stand |> plot()
norway_spruce_1_fe_stand |> plot()
spruce_beech_1_fe_stand |> plot()

# reset to previous species name settings
options(fe_spec_lang = old_opt)

}
