% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liftoneDoptimal_MLM_func.R
\name{liftoneDoptimal_MLM_func}
\alias{liftoneDoptimal_MLM_func}
\title{function of liftone for multinomial logit model}
\usage{
liftoneDoptimal_MLM_func(
  m,
  p,
  Xi,
  J,
  thetavec,
  link = "continuation",
  reltol = 1e-05,
  maxit = 500,
  p00 = NULL,
  random = FALSE,
  nram = 3
)
}
\arguments{
\item{m}{number of design points}

\item{p}{number of parameters in the multinomial logit model}

\item{Xi}{model matrix}

\item{J}{number of response levels in the multinomial logit model}

\item{thetavec}{model parameter}

\item{link}{multinomial logit model link function name "baseline", "cumulative", "adjacent", or"continuation", default to be "continuation"}

\item{reltol}{relative tolerance for convergence, default to 1e-5}

\item{maxit}{the number of maximum iteration, default to 500}

\item{p00}{specified initial approximate allocation, default to NULL, if NULL, will generate a random initial approximate allocation}

\item{random}{TRUE or FALSE, if TRUE then the function will run lift-one with additional "nram" number of random approximate allocation, default to be FALSE}

\item{nram}{when random == TRUE, the function will run lift-one nram number of initial proportion p00, default is 3}
}
\value{
p                reported D-optimal approximate allocation

p0               the initial approximate allocation that derived the reported D-optimal design

Maximum          the maximum of the determinant of the Fisher information matrix

Convergence      TRUE or FALSE, whether the algorithm converges

itmax            maximum iterations
}
\description{
function of liftone for multinomial logit model
}
\examples{
m=5
p=10
J=5
factor_x = matrix(c(-1,-25,199.96,-150,-100,16,1,23.14,196.35,0,-100,
16,1,-24.99,199.99,-150,0,16,-1,25,-200,0,0,16,-1,-25,-200,-150,0,16),ncol=6,byrow=TRUE)
Xi=rep(0,J*p*m); dim(Xi)=c(J,p,m)
hfunc.temp = function(y){
if(length(y) != 6){stop("Input should have length 6");}
 model.mat = matrix(NA, nrow=5, ncol=10, byrow=TRUE)
 model.mat[5,]=0
 model.mat[1:4,1:4] = diag(4)
 model.mat[1:4, 5] =((-1)*y[6])
 model.mat[1:4, 6:10] = matrix(((-1)*y[1:5]), nrow=4, ncol=5, byrow=TRUE)
 return(model.mat)
 }
for(i in 1:m) {
Xi[,,i]=hfunc.temp(factor_x[i,])
}
thetavec=c(-1.77994301, -0.05287782,  1.86852211, 2.76330779, -0.94437464, 0.18504420,
-0.01638597, -0.03543202, -0.07060306, 0.10347917)
liftoneDoptimal_MLM_func(m=m,p=p,Xi=Xi,J=J,thetavec=thetavec,
link="cumulative",p00=rep(1/5,5), random=FALSE)
}
