% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{Stroke_df}
\alias{Stroke_df}
\title{Ischemic Stroke Case-Control Data}
\format{
A data frame with 16,623 observations and 21 variables:
\describe{
  \item{regionnn7}{Geographic region (factor)}
  \item{case}{Case indicator for ischemic stroke (numeric)}
  \item{esex}{Sex of the participant (integer)}
  \item{eage}{Age of the participant (integer)}
  \item{htnadmbp}{Hypertension or blood pressure measure (numeric)}
  \item{nevfcur}{Smoking status (factor)}
  \item{global_stress2}{Perceived stress indicator (factor)}
  \item{whrs2tert}{Waist-to-hip ratio tertiles (factor)}
  \item{phys}{Physical activity indicator (factor)}
  \item{alcohfreqwk}{Weekly alcohol consumption frequency (factor)}
  \item{dmhba1c2}{Diabetes / HbA1c category (factor)}
  \item{cardiacrfcat}{Cardiac risk factor category (factor)}
  \item{ahei3tert}{Alternative Healthy Eating Index tertiles (factor)}
  \item{apob_apoatert}{ApoB/ApoA ratio tertiles (factor)}
  \item{subeduc}{Sub-education level (factor)}
  \item{moteduc}{Mother’s education level (factor)}
  \item{fatduc}{Father’s education level (factor)}
  \item{subhtn}{Sub-hypertension indicator (factor)}
  \item{whr}{Waist-to-hip ratio (numeric)}
  \item{apob_apoa}{ApoB/ApoA continuous ratio (numeric)}
  \item{weights}{Sample weights (numeric)}
}
}
\source{
Data taken from the causalPAF package version 1.2.5
}
\usage{
data(Stroke_df)
}
\description{
This dataset, Stroke_df, contains fictional case-control data for ischemic stroke,
including exposures, risk factors, and confounders. The dataset includes 16,623
observations and 21 variables, covering demographic details, lifestyle factors,
biomarkers, and comorbidities. Some observations contain missing values.
}
\details{
The dataset name has been kept as 'Stroke_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
