% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_truncation.R
\name{prepare_truncation_obs}
\alias{prepare_truncation_obs}
\title{Prepare truncation observations for Stan}
\usage{
prepare_truncation_obs(data, trunc_max)
}
\arguments{
\item{data}{A list of \verb{<data.frame>}s each containing date and confirm
columns. Each data set should be a snapshot of reported data.}

\item{trunc_max}{Integer, the maximum truncation delay to consider.}
}
\value{
A list containing:
\itemize{
\item \code{obs}: Matrix of observations (time x datasets)
\item \code{obs_dist}: Vector of NA counts per dataset (used to determine truncation)
\item \code{t}: Number of time points
\item \code{obs_sets}: Number of observation datasets
\item \code{dirty_obs}: The processed data.tables (ordered by nrow)
}
}
\description{
Internal function to process a list of observation snapshots
into the matrix format required by the truncation Stan model.
}
\keyword{internal}
