% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_spec.R, R/get.R
\name{get_parameters}
\alias{get_parameters}
\alias{get_parameters.dist_spec}
\alias{get_parameters.epinowfit}
\title{Get parameters from distributions or fitted models}
\usage{
get_parameters(x, ...)

\method{get_parameters}{dist_spec}(x, id = NULL, ...)

\method{get_parameters}{epinowfit}(x, ...)
}
\arguments{
\item{x}{A \code{dist_spec} object or fitted model object}

\item{...}{Additional arguments passed to methods}

\item{id}{Numeric index of the distribution to extract (for multi-
component \code{dist_spec} objects). If \code{NULL} (default), extracts from
the first component.}
}
\value{
For \code{dist_spec}: a list of distribution parameters.
For fitted models: a named list of \code{dist_spec} objects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Generic function to extract parameters. For \code{dist_spec} objects, extracts
the distribution parameters (e.g., shape and rate for Gamma). For fitted
model objects, extracts estimated parameters and delays as \code{dist_spec}
objects that can be used as priors.
}
\examples{
# For dist_spec objects
dist <- Gamma(shape = 3, rate = 2)
get_parameters(dist)

\dontrun{
# For fitted models - extract estimated distributions
dists <- get_parameters(fit)
names(dists)
}
}
