% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OpalConnection.R
\name{dsAssignResource,OpalConnection-method}
\alias{dsAssignResource,OpalConnection-method}
\title{Assign a resource}
\usage{
\S4method{dsAssignResource}{OpalConnection}(conn, symbol, resource, async = TRUE)
}
\arguments{
\item{conn}{\code{\link{OpalConnection-class}} object.}

\item{symbol}{Name of the R symbol.}

\item{resource}{Fully qualified name of a resource in Opal.}

\item{async}{Whether the result of the call should be retrieved asynchronously.
When TRUE (default) the calls are parallelized over the connections, when the
connection supports that feature, with an extra overhead of requests.}
}
\value{
A \code{\link{OpalResult-class}} object.
}
\description{
Assign a Opal resource in the DataSHIELD R session.
}
\examples{
\dontrun{
con <- dbConnect(DSOpal::Opal(), "server1",
  "administrator", "password", "https://opal-demo.obiba.org")
dsAssignResource(con, "D", "test.CNSIM")
dsDisconnect(con)
}

}
