% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPs_Output.R
\name{BK}
\alias{BK}
\alias{BK_CC}
\alias{BK_ML}
\title{Beddington and Kirkwood life-history MP}
\usage{
BK(x, Data, reps = 100, plot = FALSE)

BK_CC(x, Data, reps = 100, plot = FALSE, Fmin = 0.005)

BK_ML(x, Data, reps = 100, plot = FALSE)
}
\arguments{
\item{x}{A position in the data object}

\item{Data}{A data object}

\item{reps}{The number of stochastic samples of the MP recommendation(s)}

\item{plot}{Logical. Show the plot?}

\item{Fmin}{The minimum fishing mortality rate that is derived from the
catch-curve (interval censor).}
}
\value{
An object of class \code{\link[MSEtool]{Rec-class}} with the \code{TAC} slot populated with a numeric vector of length \code{reps}
}
\description{
Family of management procedures that sets the TAC by approximation of Fmax
based on the length at first capture relative to asymptotic length and the
von Bertalanffy growth parameter \emph{K}.
}
\details{
The TAC is calculated as:
\deqn{\textrm{TAC} = A F_{\textrm{max}}}
where \eqn{A} is (vulnerable) stock abundance, and \eqn{F_{\textrm{max}}} is calculated as:
\deqn{F_{\textrm{max}} = \frac{0.6K}{0.67-L_c/L_\infty}}
where \eqn{K} is the von Bertalanffy growth coefficient, \eqn{L_c} is the
length at first capture, and \eqn{L_\infty} is the von Bertalanffy asymptotic length

Abundance (\emph{A}) is either assumed known (\code{BK}) or estimated (\code{BK_CC} and \code{BK_ML}):
\deqn{A = \frac{\bar{C}}{\left(1-e^{-F}\right)}}
where \eqn{\bar{C}} is the mean catch, and \emph{F} is estimated.
See Functions section below for the estimation of \emph{F}.
}
\section{Functions}{
\itemize{
\item \code{BK()}: Assumes that abundance is known, i.e. \code{Data@Abun}
and \code{Data@CV_abun} contain values

\item \code{BK_CC()}: Abundance is estimated using an age-based catch curve
to estimate \emph{Z} and \emph{F}, and abundance estimated from recent catches and \emph{F}.

\item \code{BK_ML()}: Abundance is estimated using mean length
to estimate \emph{Z} and \emph{F}, and abundance estimated from recent catches and \emph{F}.

}}
\note{
Note that the Beddington-Kirkwood method is designed to estimate \eqn{F_\textrm{max}},
that is, the fishing mortality that produces the maximum yield \emph{assuming constant
recruitment independent of spawning biomass}.

Beddington and Kirkwood (2005) recommend estimating \emph{F} using other methods
(e.g., a catch curve) and comparing the estimated \emph{F} to the estimated
\eqn{F_\textrm{max}} and adjusting exploitation accordingly.
These MPs have not been implemented that way.
}
\section{Required Data}{

See \code{\link[MSEtool]{Data-class}} for information on the \code{Data} object \cr


\code{BK}: Abun, LFC, vbK, vbLinf


\code{BK_CC}: CAA, Cat, LFC, vbK, vbLinf


\code{BK_ML}: CAL, Cat, Lbar, Lc, LFC, Mort, vbK, vbLinf
}

\section{Rendered Equations}{

See \href{https://dlmtool.openmse.com/reference/BK.html}{Online Documentation} for correctly rendered equations




}

\examples{
\dontrun{
BK(1, MSEtool::SimulatedData, reps=1000, plot=TRUE)
}

\dontrun{
BK_CC(1, MSEtool::SimulatedData, reps=1000, plot=TRUE)
}

\dontrun{
BK_ML(1, MSEtool::SimulatedData, reps=100, plot=TRUE)
}

}
\references{
Beddington, J.R., Kirkwood, G.P., 2005. The estimation of
potential yield and stock status using life history parameters. Philos.
Trans. R. Soc. Lond. B Biol. Sci. 360, 163-170.
}
\author{
T. Carruthers.
}
