% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcv_measures.R
\name{rcv_measures}
\alias{rcv_measures}
\title{Model Fit Evaluation: R^2-like Measures for Logistic Regression Models with J < n}
\usage{
rcv_measures(model)
}
\arguments{
\item{model}{A fitted logistic regression model of class \code{glm}.}
}
\value{
A list containing the following measures:
\item{squared.Pearson.cc}{The squared Pearson correlation coefficient.}
\item{R_ss}{The linear regression-like measure or pseudo R-squared value.}
\item{ajusted_R}{The adjusted R-squared value, adjusted for the number of covariates and sample size.}
\item{adjust_shrink_R}{The shrinkage-adjusted R-squared value, which accounts for potential shrinkage in model estimates.}
\item{R_LS}{The log-likelihood-based R-squared value.}
}
\description{
This function computes several R^2-like measures for logistic regression models, including the squared Pearson correlation
coefficient, pseudo R-squared, adjusted R-squared, shrinkage-adjusted R-squared, and log-likelihood-based R-squared.
These metrics, adapted from Hosmer et al. (2013), are specifically designed for datasets where the number of covariates (J) is smaller than the number of data points (n),
providing a comprehensive assessment of model fit in such contexts.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5, Section 5.2.5

# Recode 'raterisk' into a binary variable 'raterisk_cat'
glow500 <- dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c("Less", "Same") ~ "C1",
    raterisk == "Greater" ~ "C2"
  )
)

# Fit a multiple logistic regression model with interactions
model.int <- glm(
  fracture ~ age + height + priorfrac + momfrac + armassist +
    raterisk_cat + age * priorfrac + momfrac * armassist,
  family = binomial,
  data = glow500
)

# Compute R-squared-like model fit statistics assuming J < n
rcv_measures(model.int)

}
\references{
Hosmer, D. W., Lemeshow, S., & Sturdivant, R. X. (2013). \emph{Applied Logistic Regression}
(3rd ed.). John Wiley & Sons, Inc.
}
\seealso{
\code{\link{cov.patterns}}, \code{\link{residuals_logistic}}
}
