% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CAESAR_enrich_pathway.R
\name{CAESAR.enrich.pathway}
\alias{CAESAR.enrich.pathway}
\title{Test whether pathways are enriched}
\usage{
CAESAR.enrich.pathway(
  seu,
  pathway.list,
  reduction = "caesar",
  pathway.cutoff = 3,
  test.type = list("ori", "gen", "wei", "max"),
  k = 5,
  wei.fun = c("weiMax", "weiGeo", "weiArith"),
  perm.num = 0,
  progress_bar = TRUE,
  ncores = 10,
  eta = 1e-04,
  genes.use = NULL,
  parallel = TRUE
)
}
\arguments{
\item{seu}{A Seurat object containing co-embedding.}

\item{pathway.list}{A list of pathways, where each pathway is characterized as a vector of gene sets.}

\item{reduction}{The embedding used when a Seurat object is provided. Default is "caesar".}

\item{pathway.cutoff}{The minimal number of genes required in a pathway. Pathways with fewer genes than this threshold will not be considered in the enrichment test.}

\item{test.type}{Type of graph-based test. This must be a list containing elements chosen from "ori", "gen", "wei", and "max", with default `list("ori", "gen", "wei", "max")`. "ori" refers to robust original edge-count test, "gen" refers to robust generalized edge-count test, "wei" refers to robust weighted edge-count test, and "max" refers to robust max-type edge-count tests. For more details, see Bai and Chu (2023).}

\item{k}{The parameter for k-minimum spanning tree. Default is 5.}

\item{wei.fun}{The weighted function used in the enrichment test. Default is "weiMax", which returns the inverse of the max node degree of an edge. "weiGeo" returns the inverse of the geometric average of the node degrees, and "weiArith" returns the inverse of the arithmetic average of the node degrees.}

\item{perm.num}{The number of permutations used to calculate the p-value (default is 0). Use 0 for getting only the approximate p-value based on asymptotic theory. Setting perm.num (e.g., perm.num = 1000) allows permutation-based p-value calculation, though this may be time-consuming.}

\item{progress_bar}{Logical, TRUE or FALSE, indicating whether a progress bar should be printed during permutations. Default is TRUE.}

\item{ncores}{The number of cores to use for parallel computing. Default is 10.}

\item{eta}{A small positive number to ensure matrix inversion stability. Default is 1e-4.}

\item{genes.use}{A vector of genes representing a gene set. All pathways will be tested for enrichment after intersecting with this gene set.}

\item{parallel}{Logical, indicating whether to use parallel computing to speed up computation. Default is TRUE.}
}
\value{
A data.frame containing the results of the test with the following columns:
\itemize{
    \item asy.ori.statistic - test statistic of robust original edge-count test.
    \item asy.ori.pval - asymptotic theory based p value of robust original edge-count test.
    \item asy.ori.pval.adj - the adjusted asymptotic theory based p value of robust original edge-count test.
    \item perm.ori.pval - permutation-based p value of robust original edge-count test, appear when permutation-based p-value is calculated.
    \item perm.ori.pval.adj - the adjusted permutation-based p value of robust original edge-count test, appear when permutation-based p-value is calculated.
    \item asy.gen.statistic - test statistic of robust generalized edge-count test.
    \item asy.gen.pval - asymptotic theory based p value of robust generalized edge-count test.
    \item asy.gen.pval.adj - the adjusted asymptotic theory based p value of robust generalized edge-count test.
    \item perm.gen.pval - permutation-based p value of robust generalized edge-count test, appear when permutation-based p-value is calculated.
    \item perm.gen.pval.adj - the adjusted permutation-based p value of robust generalized edge-count test, appear when permutation-based p-value is calculated.
    \item asy.wei.statistic - test statistic of robust weighted edge-count test.
    \item asy.wei.pval - asymptotic theory based p value of robust weighted edge-count test.
    \item asy.wei.pval.adj - the adjusted asymptotic theory based p value of robust weighted edge-count test.
    \item perm.wei.pval - permutation-based p value of robust weighted edge-count test, appear when permutation-based p-value is calculated.
    \item perm.wei.pval.adj - the adjusted permutation-based p value of robust weighted edge-count test, appear when permutation-based p-value is calculated.
    \item asy.max.statistic - test statistic of robust max-type edge-count tests.
    \item asy.max.pval - asymptotic theory based p value of robust max-type edge-count tests.
    \item asy.max.pval.adj - the adjusted asymptotic theory based p value of robust max-type edge-count tests.
    \item perm.max.pval - permutation-based p value of robust max-type edge-count tests, appear when permutation-based p-value is calculated.
    \item perm.max.pval.adj - the adjusted permutation-based p value of robust max-type edge-count tests, appear when permutation-based p-value is calculated.
}
}
\description{
This function tests whether pathways are enriched. Specifically, for a pathway (gene set), the function will assess whether these genes are clustered in the embedding space. For more details, see Bai and Chu (2023).
}
\examples{
data(toydata)

seu <- toydata$seu
pathway_list <- toydata$pathway_list

CAESAR.enrich.pathway(seu, pathway_list)
}
\references{
Bai, Y., & Chu, L. (2023). A Robust Framework for Graph-based Two-Sample Tests Using Weights. arXiv preprint arXiv:2307.12325.
}
