% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simulate_moving_circles}
\alias{simulate_moving_circles}
\title{Simulate Moving Circles Pattern}
\usage{
simulate_moving_circles(
  grid_size = 60,
  radius_seq = 6:14,
  n_steps = 10,
  center_distance = 30,
  radius2_factor = 1.5,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{grid_size}{Size of the spatial grid (default: 60)}

\item{radius_seq}{Vector of radii for circle 1 (default: 6:14)}

\item{n_steps}{Number of movement steps (default: 10)}

\item{center_distance}{Initial horizontal distance from midline for both centers (default: 30)}

\item{radius2_factor}{Circle 2 radius = radius_seq * radius2_factor (default: 1.5)}

\item{seed}{Random seed for reproducibility (default: 123)}

\item{verbose}{Logical; if TRUE, show progress bar and messages (default: TRUE)}
}
\value{
List of data frames, each containing X, Y coordinates and signal_1, signal_2 binary signals
}
\description{
Generate patterns of two circles moving toward each other horizontally.
Creates mutually exclusive signals where overlapping pixels are assigned to signal_1 (circle 1).
The circles start at fixed horizontal distances from the midline and move toward the center.
}
\examples{
\donttest{
# Generate moving circles patterns with default parameters
patterns <- simulate_moving_circles()

# Custom parameters
patterns <- simulate_moving_circles(
  grid_size = 80,
  radius_seq = c(8, 12, 16),
  n_steps = 8,
  center_distance = 35,
  radius2_factor = 1.2
)
}
}
