% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgwt_core.R
\name{sgwt_forward}
\alias{sgwt_forward}
\title{Forward SGWT transform (single or batch)}
\usage{
sgwt_forward(
  signal,
  eigenvectors,
  eigenvalues,
  scales,
  lmax = NULL,
  kernel_type = "heat"
)
}
\arguments{
\item{signal}{Input signal vector OR matrix where each column is a signal (n_vertices x n_signals)}

\item{eigenvectors}{Eigenvectors of the graph Laplacian}

\item{eigenvalues}{Eigenvalues of the graph Laplacian}

\item{scales}{Vector of scales for the wavelets}

\item{lmax}{Maximum eigenvalue (optional)}

\item{kernel_type}{Kernel family that defines both scaling and wavelet filters (default: "heat")}
}
\value{
List containing:
  \describe{
    \item{fourier_coefficients}{List with original and filtered Fourier coefficients}
    \item{filters}{Filter bank used}
  }
}
\description{
Transform signal(s) to spectral domain and apply SGWT filters.
Handles both single signals (vector) and multiple signals (matrix) efficiently.
Stores original and filtered Fourier coefficients for analysis.
}
\examples{
\donttest{
# Create example data and compute graph
data <- data.frame(x = runif(50), y = runif(50), signal = rnorm(50))
SG <- initSGWT(data, signals = "signal", J = 3)
SG <- runSpecGraph(SG, k = 10)
eigenvectors <- SG$Graph$eigenvectors
eigenvalues <- SG$Graph$eigenvalues
scales <- SG$Parameters$scales

# Single signal
signal <- data$signal
result <- sgwt_forward(signal, eigenvectors, eigenvalues, scales)

# Multiple signals (batch processing)
signals_matrix <- cbind(data$signal, data$signal * 2, data$signal * 0.5)
result <- sgwt_forward(signals_matrix, eigenvectors, eigenvalues, scales)
}
}
