% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{sgwt_energy_analysis}
\alias{sgwt_energy_analysis}
\title{Analyze SGWT energy distribution across scales in Fourier domain}
\usage{
sgwt_energy_analysis(SG, signal_name = NULL)
}
\arguments{
\item{SG}{SGWT object with Forward results computed}

\item{signal_name}{Name of signal to analyze (default: first signal)}
}
\value{
Data frame with energy analysis results computed in Fourier domain
}
\description{
Calculate and analyze energy distribution across different scales
using Fourier domain coefficients directly (consistent with Parseval's theorem).
Excludes DC component for more accurate energy analysis.
}
\examples{
\donttest{
# Create and analyze example data
data <- data.frame(x = runif(100), y = runif(100), signal1 = rnorm(100))
SG <- initSGWT(data, signals = "signal1")
SG <- runSpecGraph(SG, k = 15)
SG <- runSGWT(SG)

# Analyze energy distribution
energy_analysis <- sgwt_energy_analysis(SG, signal_name = "signal1")
print(energy_analysis)
}
}
