% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPP.R
\name{DPP}
\alias{DPP}
\title{Bayesian Hybrid Design using Dynamic Power Prior Framework}
\usage{
DPP(
  pt,
  pc,
  pch,
  pc.calib,
  nch,
  nc.range = NULL,
  r,
  q,
  alpha = 0.1,
  power = 0.8,
  delta_threshold = 0.1,
  method = "Empirical Bayes",
  theta = 0.5,
  eta = 1,
  a0c = 0.001,
  b0c = 0.001,
  a0t = 0.001,
  b0t = 0.001,
  nsim = 1e+05,
  seed = NULL
)
}
\arguments{
\item{pt}{A scalar. Response rate for experimental arm in current study.}

\item{pc}{A scalar. Response rate for control arm in current study.}

\item{pch}{A scalar. Response rate for control treatment in historical study.}

\item{pc.calib}{A scalar. Response rate for control arm in current study for
calibration. Usually, pc.calib = pch.}

\item{nch}{A scalar. Total number of patients in historical control.}

\item{nc.range}{A vector with length = 2. Search range for nc. Default is
NULL, and the range will be automatically determined.}

\item{r}{A scalar. Randomization ratio for current study. r=1 means 1:1 and
r=2 means 2:1.}

\item{q}{A scalar. Specification of n_che in terms of times of nc; i.e.
n_che = q*nc. Usually, q >= 1 and q <= nch/n_che.}

\item{alpha}{A scalar. One sided type I error rate.}

\item{power}{A scalar. Power. Default 0.8.}

\item{delta_threshold}{Borrow when abs(pc_hat (current study) - pch) <=
delta_threshold. Default 0.1.}

\item{method}{A string characters. Method for dynamic borrowing, "Empirical
Bayes", "Bayesian p", "Generalized BC", "JSD". Default "Empirical Bayes".}

\item{theta}{A scalar parameter with a range of (0, 1), and applicable to
method: "Generalized BC". Default 0.5.}

\item{eta}{A scalar parameter with a range of (0, infty), and applicable to
method: "Bayesian p", "Generalized BC", "JSD". "Generalized BC" method
requires two parameters theta and eta. Default 1.}

\item{a0c}{A scalar. Hyperprior for control response rate beta(a0c, b0c).
Default 0.001.}

\item{b0c}{A scalar. Hyperprior for control response rate beta(a0c, b0c).
Default 0.001.}

\item{a0t}{A scalar. Hyperprior for experimental response rate beta(a0t, b0t).
Default 0.001.}

\item{b0t}{A scalar. Hyperprior for experimental response rate beta(a0t, b0t).
Default 0.001.}

\item{nsim}{A scalar. Number of replications to calculate power. Default
100,000.}

\item{seed}{A scalar. seed for simulations. Default NULL.}
}
\value{
An object with values
\itemize{
\item alpha: nominal type I error rate
\item power: The calculated power by simulation.
\item type1err: empirical type I error rate.
\item tau: The calibrated threshold for statistical significance.
\item nt:  sample size for experimental arm
\item nc:  sample size for control arm
\item nche: maximum amount of borrowing in terms of number of subjects
\item delta.bound:  significance boundary of delta between the study
experimental group and study control group
\item mean.PMD: mean of posterior mean difference over nsim estimates
\item sd.PMD: standard deviation of posterior mean difference over nsim
estimates
\item mean_pc_hca: a vector of nsim length. Storing the posterior means of
pc based on hybrid control for nsim replications.
\item mean_pc_c: a vector of nsim length. Storing the posterior means of pc
based on study control for nsim replications.
}
}
\description{
This function calculates the sample size and Bayesian hybrid design parameters
using dynamic power prior framework.
}
\examples{
\donttest{
o <- DPP(pt = 0.5, pc = 0.3, pch = 0.3, pc.calib = 0.3, nch = 200, nc.range = NULL,
         r = 2, q = 1, alpha = 0.1, power = 0.8,
         delta_threshold = 0.1,
         method = "Empirical Bayes", theta = 0.5, eta = 1,
         a0c = 0.001, b0c = 0.001, a0t = 0.001, b0t = 0.001,
         nsim = 1000, seed = 2000)
print(o)
}
}
