#' @title  Simulate a sample of common factors, X
#' @description  Simulate a sample of common factors, X from its posterior (Gaussian)
#'
#' @param model.attributes  Model attributes generated by \code{initialize.model.attributes}
#' @param parm  The whole parameters from current iteration
#' @param data  The dataset
#'
#' @return  A sample of X
#' @noRd

simulated.X = function(model.attributes, parm, data){

  SigmaV.inv <- diag(1/parm$sigma2)
  Omega.inv <- parm$omega
  var.aux <- parm$omega
  chol.var.aux <- parm$omega
  
  for(j in 1:model.attributes$G){
      Omega.inv[j,,] <- solve(parm$omega[j,,])
      var.aux[j,,] <- solve(Omega.inv[j,,] + t(parm$B) %*% SigmaV.inv %*% parm$B)
      chol.var.aux[j,,] = chol(var.aux[j,,])
      }
  
  for(t in 1:model.attributes$times){
    for(i in 1:model.attributes$S){
      muselect <- parm$mu[parm$Z[i,t],]
      mean.aux = var.aux[parm$Z[i,t],,] %*% (t(parm$B) %*% SigmaV.inv%*% data[i,,t] + Omega.inv[parm$Z[i,t],,]%*%muselect)
      parm$X[i,,t] = mean.aux + t(chol.var.aux[parm$Z[i,t],,]) %*% rnorm(model.attributes$L)
    }  
  }
  return (parm)
}
