/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.util;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Field;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class ZipSecureFile
extends ZipFile {
    private static POILogger logger = POILogFactory.getLogger(ZipSecureFile.class);
    private static double MIN_INFLATE_RATIO = 0.01;
    private static long MAX_ENTRY_SIZE = 0xFFFFFFFFL;

    public static void setMinInflateRatio(double ratio) {
        MIN_INFLATE_RATIO = ratio;
    }

    public static double getMinInflateRatio() {
        return MIN_INFLATE_RATIO;
    }

    public static void setMaxEntrySize(long maxEntrySize) {
        if (maxEntrySize < 0L || maxEntrySize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max entry size is bounded [0-4GB].");
        }
        MAX_ENTRY_SIZE = maxEntrySize;
    }

    public static long getMaxEntrySize() {
        return MAX_ENTRY_SIZE;
    }

    public ZipSecureFile(File file, int mode) throws IOException {
        super(file, mode);
    }

    public ZipSecureFile(File file) throws ZipException, IOException {
        super(file);
    }

    public ZipSecureFile(String name) throws IOException {
        super(name);
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        InputStream zipIS = super.getInputStream(entry);
        return ZipSecureFile.addThreshold(zipIS);
    }

    public static ThresholdInputStream addThreshold(InputStream zipIS) throws IOException {
        ThresholdInputStream newInner;
        if (zipIS instanceof InflaterInputStream) {
            try {
                Field f = FilterInputStream.class.getDeclaredField("in");
                f.setAccessible(true);
                InputStream oldInner = (InputStream)f.get(zipIS);
                newInner = new ThresholdInputStream(oldInner, null);
                f.set(zipIS, newInner);
            }
            catch (Exception ex) {
                logger.log(5, new Object[]{"SecurityManager doesn't allow manipulation via reflection for zipbomb detection - continue with original input stream", ex});
                newInner = null;
            }
        } else {
            newInner = null;
        }
        return new ThresholdInputStream(zipIS, newInner);
    }

    public static class ThresholdInputStream
    extends PushbackInputStream {
        long counter = 0L;
        ThresholdInputStream cis;

        public ThresholdInputStream(InputStream is, ThresholdInputStream cis) {
            super(is, 1);
            this.cis = cis;
        }

        @Override
        public int read() throws IOException {
            int b = this.in.read();
            if (b > -1) {
                this.advance(1);
            }
            return b;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int cnt = this.in.read(b, off, len);
            if (cnt > -1) {
                this.advance(cnt);
            }
            return cnt;
        }

        @Override
        public long skip(long n) throws IOException {
            this.counter = 0L;
            return this.in.skip(n);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.counter = 0L;
            this.in.reset();
        }

        public void advance(int advance) throws IOException {
            this.counter += (long)advance;
            if (this.counter < MAX_ENTRY_SIZE) {
                if (this.cis == null) {
                    return;
                }
                double ratio = (double)this.cis.counter / (double)this.counter;
                if (ratio >= MIN_INFLATE_RATIO) {
                    return;
                }
            }
            throw new IOException("Zip bomb detected! The file would exceed certain limits which usually indicate that the file is used to inflate memory usage and thus could pose a security risk. You can adjust these limits via setMinInflateRatio() and setMaxEntrySize() if you need to work with files which exceed these limits. Counter: " + this.counter + ", cis.counter: " + (this.cis == null ? 0L : this.cis.counter) + ", ratio: " + (this.cis == null ? 0.0 : (double)this.cis.counter / (double)this.counter) + "Limits: MIN_INFLATE_RATIO: " + MIN_INFLATE_RATIO + ", MAX_ENTRY_SIZE: " + MAX_ENTRY_SIZE);
        }

        public ZipEntry getNextEntry() throws IOException {
            if (!(this.in instanceof ZipInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a ZipInputStream");
            }
            this.counter = 0L;
            return ((ZipInputStream)this.in).getNextEntry();
        }

        public void closeEntry() throws IOException {
            if (!(this.in instanceof ZipInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a ZipInputStream");
            }
            this.counter = 0L;
            ((ZipInputStream)this.in).closeEntry();
        }

        @Override
        public void unread(int b) throws IOException {
            if (!(this.in instanceof PushbackInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a PushbackInputStream");
            }
            if (--this.counter < 0L) {
                this.counter = 0L;
            }
            ((PushbackInputStream)this.in).unread(b);
        }

        @Override
        public void unread(byte[] b, int off, int len) throws IOException {
            if (!(this.in instanceof PushbackInputStream)) {
                throw new UnsupportedOperationException("underlying stream is not a PushbackInputStream");
            }
            this.counter -= (long)len;
            if (--this.counter < 0L) {
                this.counter = 0L;
            }
            ((PushbackInputStream)this.in).unread(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }
    }
}

