/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.attributesRI;

import dmLab.array.FArray;
import dmLab.classifier.attributeIndicators.AttributeIndicators;
import dmLab.mcfs.attributesRI.Dictionary;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.attributesRI.measuresRI.ImportanceMeasure;
import dmLab.mcfs.attributesRI.measuresRI.NodesMeasure;
import dmLab.utils.ArrayUtils;
import dmLab.utils.FileUtils;
import dmLab.utils.StringUtils;
import dmLab.utils.dataframe.DataFrame;
import dmLab.utils.list.StringList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public final class AttributesRI {
    public String label = "";
    public int mainMeasureIdx = -1;
    private ArrayList<ImportanceMeasure> measures;
    private HashMap<String, Integer> measureName;
    private float[][] importances = null;
    private Dictionary attrMap = new Dictionary();
    public static String ATTRIBUTE_LABEL = "attribute";

    public AttributesRI() {
        this.measures = new ArrayList();
        this.measureName = new HashMap();
    }

    public AttributesRI(FArray array) {
        this();
        FArray fArray = array;
        int attrNumber = fArray.attributes.length;
        int decIndex = array.getDecAttrIdx();
        for (int i = 0; i < attrNumber; ++i) {
            if (i == decIndex) continue;
            this.attrMap.addItem(array.attributes[i].name);
        }
    }

    public final void initImportances() {
        this.importances = new float[this.attrMap.size()][this.measures.size()];
    }

    /*
     * WARNING - void declaration
     */
    public final void addMeasure(ImportanceMeasure measure) {
        void var1_1;
        this.measures.add(measure);
        this.measureName.put(var1_1.name, this.measureName.size());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean addImportances(String attributeName, ExperimentIndicators experimentIndicators, AttributeIndicators indicators) {
        void var2_2;
        void var3_4;
        AttributesRI attributesRI;
        int attributeIndex = this.attrMap.getItem(attributeName);
        if (attributeIndex == -1) {
            System.err.println("Attribute does not exist in the data. *****\n attributeName: " + (String)((Object)attributesRI) + "\n experimentIndicators: " + experimentIndicators.toString() + "\n attributeIndicators: " + indicators.toString());
            return false;
        }
        void var4_6 = var3_4;
        var3_4 = var2_2;
        int n = attributeIndex;
        attributesRI = this;
        int n2 = attributesRI.measures.size();
        for (int i = 0; i < n2; ++i) {
            float[] fArray = attributesRI.importances[n];
            int n3 = i;
            fArray[n3] = (float)((double)fArray[n3] + attributesRI.measures.get(i).calcAttrImportance((ExperimentIndicators)var3_4, (AttributeIndicators)var4_6));
        }
        return true;
    }

    public final void addProjections(String[] colNames) {
        int measureIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_PROJECTIONS);
        ImportanceMeasure measure = this.measures.get(measureIdx);
        for (int i = 0; i < colNames.length; ++i) {
            int attributeIndex = this.attrMap.getItem(colNames[i]);
            float[] fArray = this.importances[attributeIndex];
            int n = measureIdx;
            fArray[n] = (float)((double)fArray[n] + measure.calcAttrImportance());
        }
    }

    public final boolean sumImportances(AttributesRI ri) {
        int size_attr = this.attrMap.size();
        if (size_attr != ri.attrMap.size()) {
            System.err.println("Destination AttributesRI size does not equal to the source AttributesRI size.");
            return false;
        }
        int size_m = this.measures.size();
        if (size_m != ri.measures.size()) {
            System.err.println("Destination AttributesRI measures number does not equal to the source AttributesRI measures number.");
            return false;
        }
        for (int i = 0; i < size_attr; ++i) {
            for (int j = 0; j < size_m; ++j) {
                float[] fArray = this.importances[i];
                int n = j;
                fArray[n] = fArray[n] + ri.importances[i][j];
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int getMeasureIndex(String measureName) {
        void var2_2;
        Integer measureIndex = this.measureName.get(measureName);
        if (measureIndex == null) {
            void var1_1;
            System.err.println("Measure " + (String)var1_1 + " does not exist");
            return -1;
        }
        return var2_2.intValue();
    }

    public final void calcNormalizedMeasures(int splits, boolean all) {
        int measureProjectionsIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_PROJECTIONS);
        int measureRIIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_RI_ROUGH);
        int measureRINormIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_RI);
        int measureClassifiersIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_CLASSIFIERS);
        int measureNodesIdx = this.getMeasureIndex(ImportanceMeasure.MEASURE_NODES);
        AttributesRI attributesRI = this;
        int size = attributesRI.attrMap.size();
        for (int i = 0; i < size; ++i) {
            if (this.importances[i][measureProjectionsIdx] != 0.0f) {
                float[] fArray = this.importances[i];
                fArray[measureRINormIdx] = fArray[measureRIIdx] / (this.importances[i][measureProjectionsIdx] * (float)splits);
            }
            if (!all) continue;
            if (this.importances[i][measureClassifiersIdx] != 0.0f) {
                float[] fArray = this.importances[i];
                fArray[measureClassifiersIdx] = fArray[measureClassifiersIdx] / (this.importances[i][measureProjectionsIdx] * (float)splits);
            }
            if (this.importances[i][measureNodesIdx] == 0.0f) continue;
            float[] fArray = this.importances[i];
            fArray[measureNodesIdx] = fArray[measureNodesIdx] / (this.importances[i][measureProjectionsIdx] * (float)splits);
        }
    }

    public final void flushMeasures() {
        int size = this.measures.size();
        for (int i = 0; i < size; ++i) {
            this.measures.get(i).flush();
        }
    }

    public final int getAttributesNumber() {
        return this.attrMap.size();
    }

    public static String[] getMeasuresNamesBasic() {
        String[] stringArray = new String[]{ImportanceMeasure.MEASURE_PROJECTIONS, ImportanceMeasure.MEASURE_CLASSIFIERS, ImportanceMeasure.MEASURE_NODES, ImportanceMeasure.MEASURE_RI};
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    public final String[] getMeasuresNames() {
        void var1_2;
        int n = this.measures.size();
        String[] array = new String[n];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.measures.get((int)i).name;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final float getImportance(String attributeName, int measureIndex) {
        int index = this.attrMap.getItem(attributeName);
        if (index != -1) {
            void var2_3;
            void var1_2;
            return this.importances[var1_2][var2_3];
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getImportanceValues(int measureIndex) {
        void var2_2;
        float[] retVal = new float[this.importances.length];
        for (int i = 0; i < this.importances.length; ++i) {
            retVal[i] = this.importances[i][measureIndex];
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final Importance[] getImportances(int measureIndex) {
        void var3_3;
        int size = this.attrMap.size();
        Importance[] imp = new Importance[size];
        for (int i = 0; i < size; ++i) {
            int index = this.attrMap.getItem(this.attrMap.getItem(i));
            imp[i] = new Importance(this.attrMap.getItem(i), this.importances[index][measureIndex]);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final float[] getMinMaxImportances(int measureIndex) {
        void var3_3;
        void var2_2;
        float minImportanceValue = this.importances[0][measureIndex];
        float maxImportanceValue = this.importances[0][measureIndex];
        for (int i = 0; i < this.importances.length; ++i) {
            float f;
            float importanceValue = this.importances[i][measureIndex];
            if (f > maxImportanceValue) {
                maxImportanceValue = importanceValue;
            }
            if (!(importanceValue < minImportanceValue)) continue;
            minImportanceValue = importanceValue;
        }
        return new float[]{var2_2, var3_3};
    }

    /*
     * WARNING - void declaration
     */
    public final Ranking getTopRanking(int measureIndex, float minRI) {
        int size = 0;
        for (int i = 0; i < this.importances.length; ++i) {
            if (!(this.importances[i][measureIndex] > minRI)) continue;
            ++size;
        }
        if (size != 0) {
            void var3_3;
            void var1_1;
            return this.getTopRankingSize((int)var1_1, (int)var3_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final Ranking getTopRankingSize(int measureIndex, int size) {
        void var1_1;
        float[][] ranking = new float[this.importances.length][2];
        if (size > this.importances.length) {
            size = this.importances.length;
        }
        for (int i = 0; i < this.importances.length; ++i) {
            ranking[i][0] = i;
            ranking[i][1] = this.importances[i][measureIndex];
        }
        ArrayUtils.qSort(ranking, 1);
        Ranking rank = new Ranking(size);
        int i = this.importances.length - 1;
        int j = 0;
        while (i >= this.importances.length - size) {
            String attr = this.attrMap.getItem((int)ranking[i][0]);
            rank.put(attr, ranking[i][1], j);
            --i;
            ++j;
        }
        rank.setMeasureName(this.measures.get((int)var1_1).name);
        return rank;
    }

    public final String toString() {
        int n;
        Object object = AttributesRI.getMeasuresNamesBasic();
        AttributesRI attributesRI = this;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = attributesRI.attrMap.size();
        boolean[] blArray = new boolean[attributesRI.measures.size()];
        Arrays.fill(blArray, false);
        HashSet<String> hashSet = object != null ? new HashSet<String>(Arrays.asList(object)) : new HashSet<String>(Arrays.asList(attributesRI.getMeasuresNames()));
        object = new StringBuffer();
        ((StringBuffer)object).append(ATTRIBUTE_LABEL);
        for (n = 0; n < blArray.length; ++n) {
            if (!hashSet.contains(attributesRI.measures.get((int)n).name)) continue;
            ((StringBuffer)object).append(',').append(attributesRI.measures.get((int)n).name);
            blArray[n] = true;
        }
        stringBuffer.append((StringBuffer)object).append('\n');
        for (n = 0; n < n2; ++n) {
            object = new StringBuffer();
            ((StringBuffer)object).append(attributesRI.attrMap.getItem(n));
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                ((StringBuffer)object).append(',').append(attributesRI.importances[n][i]);
            }
            stringBuffer.append((StringBuffer)object).append('\n');
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final DataFrame toDataFrame(String[] measuresNames) {
        void var3_6;
        int i;
        AttributesRI attributesRI = this;
        int size = attributesRI.attrMap.size();
        DataFrame df = new DataFrame(size, measuresNames.length + 1);
        new DataFrame(size, measuresNames.length + 1).separator = ",";
        ArrayList<String> names = new ArrayList<String>(measuresNames.length + 1);
        names.add(ATTRIBUTE_LABEL);
        names.addAll(Arrays.asList(measuresNames));
        String[] t = new String[1];
        df.setColNames(names.toArray(t));
        for (int i2 = 0; i2 < df.cols(); ++i2) {
            if (i2 == 0) {
                df.setColType(i2, (short)0);
                continue;
            }
            df.setColType(i2, (short)1);
        }
        boolean[] measuresMask = new boolean[this.measures.size()];
        Arrays.fill(measuresMask, false);
        for (i = 0; i < measuresMask.length; ++i) {
            if (!names.contains(this.measures.get((int)i).name)) continue;
            measuresMask[i] = true;
        }
        for (i = 0; i < size; ++i) {
            int k = 0;
            ++k;
            int n = i;
            AttributesRI attributesRI2 = this;
            df.set(i, 0, attributesRI2.attrMap.getItem(n));
            for (int j = 0; j < measuresMask.length; ++j) {
                if (!measuresMask[j]) continue;
                df.set(i, k++, Float.valueOf(this.importances[i][j]));
            }
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean load(String inFileName) {
        int i;
        BufferedReader fileReader;
        String fileName;
        String extension = "csv";
        Object object = new File(inFileName);
        if (!((File)object).exists()) {
            return false;
        }
        object = FileUtils.getFileExtension(inFileName);
        if (!((String)object).equalsIgnoreCase(extension)) {
            fileName = fileName + "." + extension;
        }
        try {
            fileReader = new BufferedReader(new FileReader(fileName));
        }
        catch (IOException iOException) {
            System.err.println("Error opening file. File: " + fileName);
            return false;
        }
        String line = null;
        int lineCount = -1;
        StringList lines = new StringList();
        int attributeIdx = -1;
        do {
            try {
                line = fileReader.readLine();
                if (line == null) break;
                if (line.trim().length() == 0) continue;
                ++lineCount;
            }
            catch (Exception e) {
                System.out.println("Error reading input file.");
                e.printStackTrace();
            }
            if (lineCount == 0) {
                String[] headerArray = StringUtils.tokenizeString(line, new char[]{','}, false);
                for (i = 0; i < headerArray.length; ++i) {
                    headerArray[i] = StringUtils.trimChars(headerArray[i], new char[]{'\"', '\''});
                    if (!headerArray[i].equalsIgnoreCase(ATTRIBUTE_LABEL)) continue;
                    attributeIdx = i;
                }
                for (i = attributeIdx + 1; i < headerArray.length; ++i) {
                    NodesMeasure measure = new NodesMeasure(null);
                    new NodesMeasure(null).name = headerArray[i];
                    this.measures.add(measure);
                }
            } else {
                lines.add(line);
            }
        } while (line != null);
        this.mainMeasureIdx = this.measures.size() - 1;
        int size = lines.size();
        this.importances = new float[size][this.measures.size()];
        for (i = 0; i < size; ++i) {
            String[] attrRIvalues = StringUtils.tokenizeString(lines.get(i), new char[]{','}, false);
            String attrName = StringUtils.trimChars(attrRIvalues[attributeIdx], new char[]{'\"', '\''});
            int attributeId = this.attrMap.addItem(attrName);
            for (int j = attributeIdx + 1; j < attrRIvalues.length; ++j) {
                this.importances[attributeId][j - (attributeIdx + 1)] = Float.parseFloat(attrRIvalues[j]);
            }
        }
        AttributesRI attributesRI = this;
        attributesRI.getMinMaxImportances(attributesRI.mainMeasureIdx);
        try {
            void var2_2;
            var2_2.close();
        }
        catch (IOException e) {
            void var1_1;
            System.err.println("Error closing file. File: " + (String)var1_1);
            e.printStackTrace();
        }
        return true;
    }
}

