/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory;

import org.chocosolver.memory.trailing.EnvironmentTrailing;
import org.chocosolver.memory.trailing.trail.IOperationTrail;
import org.chocosolver.memory.trailing.trail.IStoredBoolTrail;
import org.chocosolver.memory.trailing.trail.IStoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.IStoredIntTrail;
import org.chocosolver.memory.trailing.trail.IStoredLongTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedBoolTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedDoubleTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedIntTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedLongTrail;
import org.chocosolver.memory.trailing.trail.chunck.ChunckedOperationTrail;
import org.chocosolver.memory.trailing.trail.flatten.OperationTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredBoolTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredDoubleTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredIntTrail;
import org.chocosolver.memory.trailing.trail.flatten.StoredLongTrail;

public class EnvironmentBuilder {
    private int worldnumber = 128;
    private int worldsize = 256;
    private double loadfactor = 2.0;
    private IStoredDoubleTrail dt;
    private IStoredBoolTrail bt;
    private IStoredIntTrail it;
    private IStoredLongTrail lt;
    private IOperationTrail ot;

    public EnvironmentBuilder setWorldSize(int ws) {
        this.worldsize = ws;
        return this;
    }

    public EnvironmentBuilder setWorldNumber(int wn) {
        this.worldnumber = wn;
        return this;
    }

    public EnvironmentBuilder setLoadfactor(double lf) {
        this.loadfactor = lf;
        return this;
    }

    public EnvironmentBuilder setTrail(IStoredIntTrail t) {
        this.it = t;
        return this;
    }

    public EnvironmentBuilder setTrail(IStoredLongTrail t) {
        this.lt = t;
        return this;
    }

    public EnvironmentBuilder setTrail(IStoredDoubleTrail t) {
        this.dt = t;
        return this;
    }

    public EnvironmentBuilder setTrail(IStoredBoolTrail t) {
        this.bt = t;
        return this;
    }

    public EnvironmentBuilder setTrail(IOperationTrail t) {
        this.ot = t;
        return this;
    }

    public EnvironmentTrailing build() {
        EnvironmentTrailing env = new EnvironmentTrailing();
        if (this.bt == null) {
            this.bt = new StoredBoolTrail(this.worldsize, this.worldnumber, this.loadfactor);
        }
        if (this.it == null) {
            this.it = new StoredIntTrail(this.worldsize, this.worldnumber, this.loadfactor);
        }
        if (this.dt == null) {
            this.dt = new StoredDoubleTrail(this.worldsize, this.worldnumber, this.loadfactor);
        }
        if (this.lt == null) {
            this.lt = new StoredLongTrail(this.worldsize, this.worldnumber, this.loadfactor);
        }
        if (this.ot == null) {
            this.ot = new OperationTrail(this.worldsize, this.worldnumber, this.loadfactor);
        }
        env.setBoolTrail(this.bt);
        env.setIntTrail(this.it);
        env.setDoubleTrail(this.dt);
        env.setOperationTrail(this.ot);
        env.setLongTrail(this.lt);
        return env;
    }

    public EnvironmentBuilder fromChunk() {
        this.setTrail(new ChunckedBoolTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new ChunckedIntTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new ChunckedDoubleTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new ChunckedLongTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new ChunckedOperationTrail(this.worldsize, this.worldnumber, this.loadfactor));
        return this;
    }

    public EnvironmentBuilder fromFlat() {
        this.setTrail(new StoredBoolTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new StoredIntTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new StoredDoubleTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new StoredLongTrail(this.worldsize, this.worldnumber, this.loadfactor));
        this.setTrail(new OperationTrail(this.worldsize, this.worldnumber, this.loadfactor));
        return this;
    }
}

