/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Span
implements Comparable<Span> {
    private final int start;
    private final int end;
    private final String type;

    public Span(int s, int e, String type) {
        if (s < 0) {
            throw new IllegalArgumentException("start index must be zero or greater: " + s);
        }
        if (e < 0) {
            throw new IllegalArgumentException("end index must be zero or greater: " + e);
        }
        if (s > e) {
            throw new IllegalArgumentException("start index must not be larger than end index: start=" + s + ", end=" + e);
        }
        this.start = s;
        this.end = e;
        this.type = type;
    }

    public Span(int s, int e) {
        this(s, e, null);
    }

    public Span(Span span, int offset) {
        this(span.start + offset, span.end + offset, span.getType());
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public String getType() {
        return this.type;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean contains(Span s) {
        return this.start <= s.getStart() && s.getEnd() <= this.end;
    }

    public boolean contains(int index) {
        return this.start <= index && index < this.end;
    }

    public boolean startsWith(Span s) {
        return this.getStart() == s.getStart() && this.contains(s);
    }

    public boolean intersects(Span s) {
        int sstart = s.getStart();
        return this.contains(s) || s.contains(this) || this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd();
    }

    public boolean crosses(Span s) {
        int sstart = s.getStart();
        return !this.contains(s) && !s.contains(this) && (this.getStart() <= sstart && sstart < this.getEnd() || sstart <= this.getStart() && this.getStart() < s.getEnd());
    }

    public CharSequence getCoveredText(CharSequence text) {
        if (this.getEnd() > text.length()) {
            throw new IllegalArgumentException("The span " + this.toString() + " is outside the given text which has length " + text.length() + "!");
        }
        return text.subSequence(this.getStart(), this.getEnd());
    }

    @Override
    public int compareTo(Span s) {
        if (this.getStart() < s.getStart()) {
            return -1;
        }
        if (this.getStart() == s.getStart()) {
            if (this.getEnd() > s.getEnd()) {
                return -1;
            }
            if (this.getEnd() < s.getEnd()) {
                return 1;
            }
            if (this.getType() == null && s.getType() == null) {
                return 0;
            }
            if (this.getType() != null && s.getType() != null) {
                return this.getType().compareTo(s.getType());
            }
            if (this.getType() != null) {
                return -1;
            }
            return 1;
        }
        return 1;
    }

    public int hashCode() {
        int res = 23;
        res = res * 37 + this.getStart();
        res = res * 37 + this.getEnd();
        res = this.getType() == null ? (res *= 37) : res * 37 + this.getType().hashCode();
        return res;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            result = true;
        } else if (o instanceof Span) {
            Span s = (Span)o;
            result = !(this.getStart() != s.getStart() || this.getEnd() != s.getEnd() || this.getType() != null && !this.type.equals(s.getType()) || s.getType() != null && !s.getType().equals(this.getType()));
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder toStringBuffer = new StringBuilder(15);
        toStringBuffer.append("[");
        toStringBuffer.append(this.getStart());
        toStringBuffer.append("..");
        toStringBuffer.append(this.getEnd());
        toStringBuffer.append(")");
        if (this.getType() != null) {
            toStringBuffer.append(" ");
            toStringBuffer.append(this.getType());
        }
        return toStringBuffer.toString();
    }

    public static String[] spansToStrings(Span[] spans, CharSequence s) {
        String[] tokens = new String[spans.length];
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            tokens[si] = ((Object)spans[si].getCoveredText(s)).toString();
        }
        return tokens;
    }

    public static String[] spansToStrings(Span[] spans, String[] tokens) {
        String[] chunks = new String[spans.length];
        StringBuilder cb = new StringBuilder();
        int sl = spans.length;
        for (int si = 0; si < sl; ++si) {
            cb.setLength(0);
            for (int ti = spans[si].getStart(); ti < spans[si].getEnd(); ++ti) {
                cb.append(tokens[ti]).append(" ");
            }
            chunks[si] = cb.substring(0, cb.length() - 1);
        }
        return chunks;
    }
}

