/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.convert;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToSentenceSampleStream<T>
extends FilterObjectStream<T, SentenceSample> {
    private final Detokenizer detokenizer;
    private final int chunkSize;

    AbstractToSentenceSampleStream(Detokenizer detokenizer, ObjectStream<T> samples, int chunkSize) {
        super(samples);
        if (detokenizer == null) {
            throw new IllegalArgumentException("detokenizer must not be null!");
        }
        this.detokenizer = detokenizer;
        if (chunkSize < 0) {
            throw new IllegalArgumentException("chunkSize must be zero or larger but was " + chunkSize + "!");
        }
        this.chunkSize = chunkSize > 0 ? chunkSize : Integer.MAX_VALUE;
    }

    protected abstract String[] toSentence(T var1);

    @Override
    public SentenceSample read() throws IOException {
        Object posSample;
        ArrayList<String[]> sentences = new ArrayList<String[]>();
        for (int chunks = 0; (posSample = this.samples.read()) != null && chunks < this.chunkSize; ++chunks) {
            sentences.add(this.toSentence(posSample));
        }
        if (sentences.size() > 0) {
            return new SentenceSample(this.detokenizer, (String[][])sentences.toArray((T[])new String[sentences.size()][]));
        }
        if (posSample != null) {
            return this.read();
        }
        return null;
    }
}

