## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(cli)
library(UAHDataScienceSC)

## ----install-package, eval = FALSE--------------------------------------------
#  install.packages("UAHDataScienceSC")

## ----load-package-------------------------------------------------------------
library(UAHDataScienceSC)

## ----load-flower-db-----------------------------------------------------------
data("db_flowers")
head(db_flowers)

## ----load-and-db--------------------------------------------------------------
data("db_per_and.rda")
head(db_per_and)

## ----load-or-db---------------------------------------------------------------
data("db_per_or.rda")
head(db_per_or)

## ----load-xor-db--------------------------------------------------------------
data("db_per_xor.rda")
head(db_per_xor)

## ----load-db2-----------------------------------------------------------------
data(db2)
head(db2)

## ----load-db3-----------------------------------------------------------------
data(db3)
head(db3)

## ----load-db1rl---------------------------------------------------------------
data("db1rl")
head(db1rl)

## ----knn-basic-usage----------------------------------------------------------
result <- knn(
  data = db_flowers,
  ClassLabel = "ClassLabel",
  p1 = c(4.7, 1.2, 5.3, 2.1),
  d_method = "euclidean",
  k = 3
)
print(result)

## ----knn-interactive-usage----------------------------------------------------
result <- knn(
  data = db_flowers,
  ClassLabel = "ClassLabel",
  p1 = c(4.7, 1.2, 5.3, 2.1),
  d_method = "euclidean",
  k = 3,
  learn = TRUE,
  waiting = FALSE
)

## ----decision-tree-usage------------------------------------------------------
tree <- decision_tree(
  data = db2,
  classy = "VehicleType",
  m = 4,
  method = "gini",
  learn = TRUE
)
print(tree)

## ----perceptron-usage---------------------------------------------------------
weights <- perceptron(
  training_data = db_per_and,
  to_clasify = c(0, 0, 1),
  activation_method = "swish",
  max_iter = 1000,
  learning_rate = 0.1,
  learn = TRUE
)

## ----regression-usage---------------------------------------------------------
# Linear regression
linear_model <- multivariate_linear_regression(
  data = db1rl,
  learn = TRUE
)

# Polynomial regression
poly_model <- polynomial_regression(
  data = db1rl,
  degree = 4,
  learn = TRUE
)

