/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.utils;

import gov.nih.ncats.ifx.qhts.utils.HtsUtil;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class PlateUtil {
    public double TINY = 1.0E-10;
    public static int colNo = 48;
    public static int rowNo = 32;
    private static HashMap cacheMap = new HashMap();
    public static double OUTLIER_PCT_CTL = 0.15;
    public static int CMPD_START_COL = 4;
    public static double OUTLIER_PCT = 0.1;
    public static char OUTLIER_DIRECTION = (char)32;
    public static double CONTROL_OUTLIER_DELTA = 3.0;
    private static PreparedStatement plateConcIS;
    private static PreparedStatement plateSampleIS;
    private static PreparedStatement plateConc384IS;
    private static PreparedStatement plateSample384IS;
    private static PreparedStatement plateConc96IS;
    private static PreparedStatement plateSample96IS;

    public static void main(String[] args) {
        try {
            int i;
            OUTLIER_PCT = 0.2;
            OUTLIER_DIRECTION = (char)45;
            ArrayList list = new ArrayList();
            for (i = 0; i < 10; ++i) {
                list.add(String.valueOf(i));
            }
            list = PlateUtil.removeOutlier(list);
            for (i = 0; i < list.size(); ++i) {
                System.out.println(list.get(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setRowCol(int rn, int cn) {
        rowNo = rn;
        colNo = cn;
    }

    public static void setCmpdStartCol(int col) {
        CMPD_START_COL = col;
    }

    public static void setOutlierPct(double td) {
        OUTLIER_PCT = td;
    }

    public static double getOutlierPct() {
        return OUTLIER_PCT;
    }

    public static ArrayList removeOutlier1(ArrayList list) {
        int i;
        double[] values = new double[list.size()];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = Double.parseDouble((String)list.get(i2));
        }
        Arrays.sort(values);
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i3 = 0; i3 < values.length; ++i3) {
            list2.add(String.valueOf(values[i3]));
        }
        int no = list2.size();
        int nt = (int)((double)no * 0.375);
        int nb = (int)((double)no * 0.375);
        for (i = 0; i < nt; ++i) {
            list2.remove(list2.size() - 1);
        }
        for (i = 0; i < nb; ++i) {
            list2.remove(0);
        }
        return list2;
    }

    public static ArrayList removeOutlier(ArrayList list) {
        ArrayList<String> list2;
        block7: {
            int n;
            block8: {
                block6: {
                    int i;
                    double[] values = new double[list.size()];
                    for (int i2 = 0; i2 < values.length; ++i2) {
                        values[i2] = Double.parseDouble((String)list.get(i2));
                    }
                    Arrays.sort(values);
                    list2 = new ArrayList<String>();
                    for (int i3 = 0; i3 < values.length; ++i3) {
                        list2.add(String.valueOf(values[i3]));
                    }
                    int no = list2.size();
                    n = (int)((double)no * OUTLIER_PCT);
                    if (OUTLIER_DIRECTION != ' ') break block6;
                    for (i = 0; i < n; ++i) {
                        list2.remove(0);
                    }
                    for (i = 0; i < n; ++i) {
                        list2.remove(list2.size() - 1);
                    }
                    break block7;
                }
                if (OUTLIER_DIRECTION != '+') break block8;
                for (int i = 0; i < n; ++i) {
                    list2.remove(list2.size() - 1);
                }
                break block7;
            }
            if (OUTLIER_DIRECTION != '-') break block7;
            for (int i = 0; i < n; ++i) {
                list2.remove(0);
            }
        }
        return list2;
    }

    public static double calcMean(double[][] data, int startCol, boolean[][] flags) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = startCol; j < colNo; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j])) continue;
                list.add(String.valueOf(data[i][j]));
            }
        }
        list = PlateUtil.removeOutlier(list);
        int no = list.size();
        double[] values = new double[no];
        for (int i = 0; i < no; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        double mean = 0.0;
        for (int i = 0; i < no; ++i) {
            mean += values[i];
        }
        return mean / (double)no;
    }

    public static double calcMean(double[][] data, int col) {
        double mean = 0.0;
        for (int i = 0; i < data.length; ++i) {
            mean += data[i][col];
        }
        return mean / (double)data.length;
    }

    public static double calcMean(double[][] data, String[][] labels, String label, boolean[][] flags) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                list.add(String.valueOf(data[i][j]));
            }
        }
        list = PlateUtil.removeOutlier(list);
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        double mean = 0.0;
        for (int i = 0; i < values.length; ++i) {
            mean += values[i];
        }
        return mean / (double)values.length;
    }

    public static double calcMedian(double[][] data, int startCol) {
        return PlateUtil.calcMedian(data, startCol, null);
    }

    public static double calcMedian(double[][] data, int startCol, boolean[][] flags) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = startCol; j < colNo; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j])) continue;
                list.add(String.valueOf(data[i][j]));
            }
        }
        if (list.size() == 0) {
            return Double.NaN;
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcMedianCol(double[][] data, int c) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            if (Double.isNaN(data[i][c])) continue;
            list.add(String.valueOf(data[i][c]));
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcMedianCol(double[][] data, int c, int r1, int r2) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = r1; i < r2; ++i) {
            if (Double.isNaN(data[i][c])) continue;
            list.add(String.valueOf(data[i][c]));
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcMedianCol(double[][] data, int rowNo, int c) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            if (Double.isNaN(data[i][c])) continue;
            list.add(String.valueOf(data[i][c]));
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcStdCol(double[][] data, int rowNo, int c) {
        double median = PlateUtil.calcMedianCol(data, rowNo, c);
        double std = 0.0;
        for (int i = 0; i < rowNo; ++i) {
            std += (data[i][c] - median) * (data[i][c] - median);
        }
        return Math.sqrt(std / (double)(data.length - 1));
    }

    public static double calcStdCol(double[][] data, int c, double median) {
        double std = 0.0;
        for (int i = 0; i < data.length; ++i) {
            std += (data[i][c] - median) * (data[i][c] - median);
        }
        return Math.sqrt(std / (double)(data.length - 1));
    }

    public static double calcMedian(double[] values, boolean[] flags) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (flags != null && !flags[i]) continue;
            list.add(String.valueOf(values[i]));
        }
        return PlateUtil.calcMedian(list);
    }

    public static double calcMedian(double[][] data, String[][] labels, String label, boolean[][] flags) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                list.add(String.valueOf(data[i][j]));
            }
        }
        if (list.size() == 0) {
            return Double.NaN;
        }
        list = PlateUtil.removeOutlier(list);
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        if (values.length % 2 == 0) {
            int mid = values.length / 2;
            return (values[mid] + values[mid - 1]) / 2.0;
        }
        return values[values.length / 2];
    }

    public static double calcMedian(ArrayList list) {
        double[] values = new double[list.size()];
        for (int k = 0; k < list.size(); ++k) {
            values[k] = Double.parseDouble((String)list.get(k));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcMedian(double[] values) {
        double[] values2 = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            values2[i] = values[i];
        }
        Arrays.sort(values2);
        int k = values2.length / 2;
        return values2[k];
    }

    public static double calcMedianToken(double[][] data, String[][] labels, String tok, boolean[][] flags) throws Exception {
        double dm = 0.0;
        if (HtsUtil.isNumber(tok)) {
            dm = PlateUtil.calcMedian(data, Integer.parseInt(tok), flags);
        } else if (HtsUtil.isDecimal(tok)) {
            dm = Double.parseDouble(tok);
        } else if (tok.length() == 1) {
            dm = PlateUtil.calcMedian(data, labels, tok, flags);
        } else {
            throw new Exception("Wrong format: " + tok);
        }
        return dm;
    }

    public static double calcMedian(double[][] data, String[][] labels, String label, double d0, boolean[][] flags) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                list.add(String.valueOf(Math.abs(data[i][j] - d0)));
            }
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcMedian(double[][] data, int startCol, double d0, boolean[][] flags) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = startCol; j < colNo; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j])) continue;
                list.add(String.valueOf(Math.abs(data[i][j] - d0)));
            }
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcStd(double[] data, double median) {
        double std = 0.0;
        for (int i = 0; i < data.length; ++i) {
            std += (data[i] - median) * (data[i] - median);
        }
        return Math.sqrt(std / (double)(data.length - 1));
    }

    public static double calcStd(int startCol, double[][] data, double median) throws Exception {
        double std = 0.0;
        for (int i = 0; i < rowNo; ++i) {
            for (int j = startCol; j < colNo; ++j) {
                std += (data[i][j] - median) * (data[i][j] - median);
            }
        }
        int no = rowNo * (colNo - startCol) - 1;
        return Math.sqrt(std / (double)no);
    }

    public static double calcStd(ArrayList list, double median, int delta) throws Exception {
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        double std = 0.0;
        for (int i = delta; i < values.length - delta; ++i) {
            std += (values[i] - median) * (values[i] - median);
        }
        return Math.sqrt(std / (double)(values.length - 2 * delta - 1));
    }

    public static double calcStd(double[][] data, String[][] labels, String label, double d0, double pct) {
        return PlateUtil.calcStd(data, labels, label, d0, null);
    }

    public static double calcStd(double[][] data, String[][] labels, String label, double d0, boolean[][] flags) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                double td = data[i][j] - d0;
                list.add(String.valueOf(td * td));
            }
        }
        list = PlateUtil.removeOutlier(list);
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        double std = 0.0;
        for (int i = 0; i < values.length; ++i) {
            std += values[i];
        }
        return Math.sqrt(std / (double)(values.length - 1));
    }

    public static double calcRobustStd(double[][] data, String[][] labels, String label, double d0, boolean[][] flags) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                double td = Math.abs(data[i][j] - d0);
                list.add(String.valueOf(td));
            }
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        return values[values.length / 2];
    }

    public static double calcStd(double[][] data, int startCol, double d0) {
        return PlateUtil.calcStd(data, startCol, d0, null);
    }

    public static double calcStd(double[][] data, int startCol, double d0, boolean[][] flags) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = startCol; j < colNo; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j])) continue;
                double td = data[i][j] - d0;
                list.add(String.valueOf(td * td));
            }
        }
        list = PlateUtil.removeOutlier(list);
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        double std = 0.0;
        for (int i = 0; i < values.length; ++i) {
            std += values[i];
        }
        return Math.sqrt(std / (double)(values.length - 1));
    }

    public static double[] calcMinMax(double[][] data, String[][] labels, String label, boolean[][] flags, double pct) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                list.add(String.valueOf(data[i][j]));
            }
        }
        if (list.size() == 0) {
            return null;
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        int no = (int)((double)values.length * pct);
        list = new ArrayList();
        for (int i = 0; i < no; ++i) {
            list.add(String.valueOf(values[i]));
        }
        double min = PlateUtil.calcMedian(list);
        list = new ArrayList();
        int len = values.length;
        for (int i = 0; i < no; ++i) {
            list.add(String.valueOf(values[len - i - 1]));
        }
        double max = PlateUtil.calcMedian(list);
        double[] retValues = new double[]{min, max};
        return retValues;
    }

    public static double[] calcMinMax(double[][] data, String[][] labels, String label, boolean[][] flags) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < rowNo; ++i) {
            for (int j = 0; j < labels[i].length; ++j) {
                if (flags != null && !flags[i][j] || Double.isNaN(data[i][j]) || !labels[i][j].equals(label)) continue;
                list.add(String.valueOf(data[i][j]));
            }
        }
        if (list.size() == 0) {
            return null;
        }
        double[] values = new double[list.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Double.parseDouble((String)list.get(i));
        }
        Arrays.sort(values);
        double[] retValues = new double[]{values[0], values[values.length - 1]};
        return retValues;
    }
}

