/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Statistical_Classifiers.ClassifierLinearLMS;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Shared.ClassicalOptim.GCNet;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import keel.Algorithms.Statistical_Classifiers.Shared.DiscrAnalysis.AD;
import keel.Algorithms.Statistical_Classifiers.Shared.MatrixCalcs.MatrixCalcs;
import org.core.Randomize;

public class ClassifierLinearLMS {
    static Randomize rand;

    private static void linearClassifierLMS(boolean tty, ProcessConfig pc) {
        try {
            int i;
            ProcessDataset pd = new ProcessDataset();
            String line = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processClassifierDataset(line, true);
            } else {
                pd.oldClusteringProcess(line);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            pd.showDatasetStatistics();
            double[][] X = pd.getX();
            int[] C = pd.getC();
            int[] Ct = new int[C.length];
            int nClasses = pd.getNclasses();
            double[] maxInput = pd.getImaximum();
            double[] minInput = pd.getIminimum();
            int[] nInputFolds = new int[nInputs];
            double[][] Cbin = new double[nData][nClasses];
            for (i = 0; i < nData; ++i) {
                Cbin[i][C[i]] = 1.0;
            }
            for (i = 0; i < X.length; ++i) {
                Ct[i] = -1;
            }
            int nLayers = 0;
            int[] ELEM = new int[nLayers];
            int dimWeight = 0;
            if (nLayers == 0) {
                dimWeight = (nInputs + 1) * nClasses;
            } else {
                dimWeight = (nInputs + 1) * ELEM[0];
                for (int i2 = 1; i2 < nLayers; ++i2) {
                    dimWeight += (ELEM[i2 - 1] + 1) * ELEM[i2];
                }
                dimWeight += nClasses * (ELEM[nLayers - 1] + 1);
            }
            double[] weights = new double[dimWeight];
            GCNet gcn = new GCNet();
            double error = gcn.nntrain(nInputs, nClasses, X, Cbin, ELEM, weights, rand);
            double faults = 0.0;
            double debugRMS = 0.0;
            try {
                for (int i3 = 0; i3 < X.length; ++i3) {
                    double[] resp = gcn.nnoutput(X[i3]);
                    int theClass = AD.argmax(resp);
                    for (int i1 = 0; i1 < resp.length; ++i1) {
                        debugRMS += (resp[i1] - Cbin[i3][i1]) * (resp[i1] - Cbin[i3][i1]);
                    }
                    if (theClass != C[i3]) {
                        faults += 1.0;
                    }
                    Ct[i3] = theClass;
                }
                System.out.println("Failures=" + faults + " size=" + nData);
                System.out.println("Debug RMS=" + (debugRMS /= (double)X.length));
                System.out.println("Train error=" + (faults /= (double)nData));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.trainingResults(C, Ct);
            ProcessDataset pdt = new ProcessDataset();
            line = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processClassifierDataset(line, false);
            } else {
                pdt.oldClusteringProcess(line);
            }
            int nTest = pdt.getNdata();
            int npVariables = pdt.getNvariables();
            int npInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (npInputs != nInputs) {
                throw new IOException("IOErr test file");
            }
            double[][] Xp = pdt.getX();
            int[] Cp = pdt.getC();
            int[] Co = new int[Cp.length];
            try {
                faults = 0.0;
                for (int i4 = 0; i4 < Xp.length; ++i4) {
                    double[] resp = gcn.nnoutput(Xp[i4]);
                    int theClass = AD.argmax(resp);
                    if (theClass != Cp[i4]) {
                        faults += 1.0;
                    }
                    Co[i4] = theClass;
                }
                System.out.println("Failures=" + faults + " total=" + Xp.length);
                System.out.println("Test error=" + (faults /= (double)Cp.length));
            }
            catch (Exception e) {
                System.out.println(e.toString());
            }
            pc.results(Cp, Co);
            double[][] Ys = new double[X.length][nClasses];
            double[][] Xs = new double[X.length][X[0].length + 1];
            double[][] A = new double[X[0].length + 1][1];
            for (int i5 = 0; i5 < Xs.length; ++i5) {
                int j;
                for (j = 0; j < nClasses; ++j) {
                    Ys[i5][j] = Cbin[i5][j];
                }
                Xs[i5][0] = 1.0;
                for (j = 1; j < Xs[0].length; ++j) {
                    Xs[i5][j] = X[i5][j - 1];
                }
            }
            try {
                A = MatrixCalcs.matmul(MatrixCalcs.matmul(MatrixCalcs.inv(MatrixCalcs.matmul(MatrixCalcs.tr(Xs), Xs)), MatrixCalcs.tr(Xs)), Ys);
                double[][] Cs = new double[Ys.length][Ys[0].length];
                Cs = MatrixCalcs.matmul(Xs, A);
                debugRMS = 0.0;
                for (int i6 = 0; i6 < Cs.length; ++i6) {
                    for (int j = 0; j < Cs[i6].length; ++j) {
                        debugRMS += (Cs[i6][j] - Ys[i6][j]) * (Cs[i6][j] - Ys[i6][j]);
                    }
                }
                System.out.println("DEBUG RMS PSEUDOINVERSE: " + (debugRMS /= (double)Cs.length));
            }
            catch (Exception e) {
                System.err.println(e + " Matrix Calcs");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " Input file not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        ClassifierLinearLMS cl = new ClassifierLinearLMS();
        ClassifierLinearLMS.linearClassifierLMS(tty, pc);
    }
}

