/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.binarray.rec;

import net.sourceforge.jclec.binarray.BinArrayIndividual;
import net.sourceforge.jclec.binarray.BinArrayRecombinator;

public class OnePointCrossover
extends BinArrayRecombinator {
    private static final long serialVersionUID = 3689351022304639024L;

    public boolean equals(Object other) {
        return other instanceof OnePointCrossover;
    }

    @Override
    protected void recombineNext() {
        int gl = this.species.getGenotypeLength();
        BinArrayIndividual p0 = (BinArrayIndividual)this.parentsBuffer.get(this.parentsCounter);
        BinArrayIndividual p1 = (BinArrayIndividual)this.parentsBuffer.get(this.parentsCounter + 1);
        byte[] p0_genome = (byte[])p0.getGenotype();
        byte[] p1_genome = (byte[])p1.getGenotype();
        byte[] s0_genome = new byte[gl];
        byte[] s1_genome = new byte[gl];
        int cp = this.randgen.choose(0, gl);
        System.arraycopy(p0_genome, 0, s0_genome, 0, cp);
        System.arraycopy(p1_genome, cp, s0_genome, cp, gl - cp);
        System.arraycopy(p1_genome, 0, s1_genome, 0, cp);
        System.arraycopy(p0_genome, cp, s1_genome, cp, gl - cp);
        this.sonsBuffer.add(this.species.createIndividual(s0_genome));
        this.sonsBuffer.add(this.species.createIndividual(s1_genome));
    }
}

