/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.matrices.Householder;
import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.matrices.MatrixException;
import ec.tstoolkit.maths.matrices.SubMatrix;
import ec.tstoolkit.maths.matrices.SymmetricMatrix;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.ParamValidation;

public class QRMarquardt
implements ISsqFunctionMinimizer {
    private int m_niter;
    private int m_maxiter = 100;
    private boolean m_checkdecrease = false;
    private boolean m_strict = false;
    private double[] m_beta;
    private double m_lambda = 0.001;
    private double m_istep = 4.0;
    private double m_dstep = 0.5;
    private double m_criterion = 1.0E-4;
    private double m_curlambda;
    private double m_dmax;
    private double m_obj0;
    private double m_obj1;
    private double[] m_e;
    private Matrix m_dfn;
    private Matrix m_alpha;
    private ISsqFunction m_fn;
    private ISsqFunctionInstance m_ftry;
    private DataBlock m_a;
    private double m_tol;

    public QRMarquardt() {
    }

    public QRMarquardt(QRMarquardt qrm) {
        this.m_criterion = qrm.m_criterion;
        this.m_dstep = qrm.m_dstep;
        this.m_istep = qrm.m_istep;
        this.m_lambda = qrm.m_lambda;
        this.m_maxiter = qrm.m_maxiter;
        this.m_tol = qrm.m_tol;
    }

    protected void calcCurvature() {
        if (this.m_alpha != null) {
            return;
        }
        int ne = this.m_e.length;
        int n = this.m_beta.length;
        this.m_alpha = new Matrix(n, n);
        SubMatrix dfn = this.m_dfn.subMatrix(n, ne, 0, n);
        for (int c = 0; c < n; ++c) {
            for (int r = 0; r <= c; ++r) {
                this.m_alpha.set(c, r, dfn.column(c).dot(dfn.column(r)));
            }
        }
        SymmetricMatrix.fromLower(this.m_alpha);
        this.m_alpha.mul(2.0);
    }

    protected void clear() {
        this.m_ftry = null;
        this.m_fn = null;
        this.m_e = null;
        this.m_alpha = null;
        this.m_a = null;
        this.m_beta = null;
    }

    protected void endIteration() {
    }

    @Override
    public ISsqFunctionMinimizer exemplar() {
        QRMarquardt qrm = new QRMarquardt();
        qrm.m_criterion = this.m_criterion;
        qrm.m_dstep = this.m_dstep;
        qrm.m_istep = this.m_istep;
        qrm.m_lambda = this.m_lambda;
        qrm.m_maxiter = this.m_maxiter;
        qrm.m_tol = this.m_tol;
        qrm.m_checkdecrease = this.m_checkdecrease;
        qrm.m_strict = this.m_strict;
        return qrm;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_criterion;
    }

    public double getCurrentLambda() {
        return this.m_curlambda;
    }

    @Override
    public Matrix getCurvature() {
        this.calcCurvature();
        return this.m_alpha;
    }

    @Override
    public double[] getGradient() {
        int n = this.m_beta.length;
        double[] g = new double[n];
        for (int c = 0; c < n; ++c) {
            g[c] = -this.m_beta[c];
        }
        return g;
    }

    public boolean isCheckingDecrease() {
        return this.m_checkdecrease;
    }

    public void setCheckDecrease(boolean decrease) {
        this.m_checkdecrease = decrease;
    }

    public boolean isStrict() {
        return this.m_strict;
    }

    public void setStrict(boolean value) {
        this.m_strict = value;
    }

    public double getDecreaseStep() {
        return this.m_dstep;
    }

    public double getIncreaseStep() {
        return this.m_istep;
    }

    public double getInitialLambda() {
        return this.m_lambda;
    }

    @Override
    public int getIterCount() {
        return this.m_niter;
    }

    @Override
    public int getMaxIter() {
        return this.m_maxiter;
    }

    @Override
    public ISsqFunctionInstance getResult() {
        return this.m_ftry;
    }

    @Override
    public double getObjective() {
        return this.m_ftry == null ? Double.NaN : this.m_ftry.getSsqE();
    }

    protected void initialize(ISsqFunctionInstance start) {
        this.m_niter = 0;
        this.m_ftry = start;
        IReadDataBlock p = start.getParameters();
        this.m_a = new DataBlock(p.getLength());
        p.copyTo(this.m_a.getData(), 0);
        int n = this.m_a.getLength();
        this.m_beta = new double[n];
        this.m_curlambda = 0.0;
        this.m_e = this.m_ftry.getE();
        this.m_obj0 = this.m_ftry.getSsqE();
    }

    protected boolean iterate(boolean bnewval) {
        ++this.m_niter;
        int ne = this.m_e.length;
        int n = this.m_beta.length;
        int nc = ne + n;
        if (bnewval) {
            try {
                ISsqFunctionDerivatives der = this.m_fn.getDerivatives(this.m_ftry);
                double[] grad = der.getGradient();
                this.m_dfn = new Matrix(nc, n);
                DataBlockIterator dfn = this.m_dfn.subMatrix(0, ne, 0, n).columns();
                DataBlock cdfn = dfn.getData();
                do {
                    int i = dfn.getPosition();
                    double[] de = der.dEdX(i);
                    cdfn.copy(new DataBlock(de));
                    this.m_beta[i] = -grad[i];
                } while (dfn.next());
            }
            catch (RuntimeException der) {
                // empty catch block
            }
        }
        double[] errtmp = new double[nc];
        for (int r = 0; r < ne; ++r) {
            errtmp[r] = -this.m_e[r];
        }
        if (this.m_curlambda != 0.0) {
            double sg = Math.sqrt(this.m_curlambda);
            for (int c = 0; c < n; ++c) {
                this.m_dfn.set(ne + c, c, sg);
            }
        }
        double sum = 0.0;
        this.m_dmax = 0.0;
        DataBlock atry = this.m_a.deepClone();
        try {
            Householder qr = new Householder(true);
            qr.decompose(this.m_dfn);
            double[] da = qr.solve(errtmp);
            for (int i = 0; i < n; ++i) {
                atry.add(i, da[i]);
                sum += (0.5 * this.m_beta[i] + this.m_curlambda * da[i]) * da[i];
                double dmax = Math.abs(da[i]) / (1.0 + Math.abs(this.m_a.get(i)));
                if (!(dmax > this.m_dmax)) continue;
                this.m_dmax = dmax;
            }
        }
        catch (MatrixException ex) {
            return false;
        }
        if (sum < 0.0) {
            return false;
        }
        ParamValidation val = this.m_fn.getDomain().validate(atry);
        if (val == ParamValidation.Invalid) {
            throw new FunctionException("Boundaries error");
        }
        ISsqFunctionInstance ftry = this.m_fn.ssqEvaluate(atry);
        this.m_obj1 = ftry != null ? ftry.getSsqE() : Double.MAX_VALUE;
        double s = (this.m_obj0 - this.m_obj1) / sum;
        if (s > 0.0) {
            this.m_ftry = ftry;
            this.m_a = atry;
            this.m_e = ftry.getE();
        }
        if (s < 0.25) {
            this.m_curlambda = this.m_curlambda == 0.0 ? this.m_lambda : (this.m_curlambda *= this.m_istep);
        }
        if (s > 0.75) {
            this.m_curlambda *= this.m_dstep;
        }
        return s > 0.0;
    }

    public boolean minimize(ISsqFunction fn, IReadDataBlock pstart) {
        return this.minimize(fn, fn.ssqEvaluate(pstart));
    }

    @Override
    public boolean minimize(ISsqFunction fn, ISsqFunctionInstance start) {
        this.clear();
        this.m_fn = fn;
        this.initialize(start);
        if (this.m_a.getLength() == 0) {
            return true;
        }
        boolean bnewval = true;
        do {
            bnewval = this.iterate(bnewval);
        } while (this.nextIteration());
        this.endIteration();
        return this.m_niter < this.m_maxiter;
    }

    protected boolean nextIteration() {
        if (this.m_niter >= this.m_maxiter) {
            return false;
        }
        if (this.m_checkdecrease && this.m_obj1 > this.m_obj0) {
            return true;
        }
        double dobj = Math.abs(this.m_obj0 - this.m_obj1) / (1.0 + Math.abs(this.m_obj0));
        if (this.m_obj1 < this.m_obj0) {
            this.m_obj0 = this.m_obj1;
        }
        if (this.m_niter >= this.m_maxiter) {
            return false;
        }
        if (this.m_strict) {
            return dobj > this.m_criterion || this.m_dmax > Math.sqrt(this.m_criterion);
        }
        return dobj > this.m_criterion && this.m_dmax > Math.sqrt(this.m_criterion);
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_criterion = value;
    }

    public void setDecreaseStep(double value) {
        this.m_dstep = value;
    }

    public void setIncreaseStep(double value) {
        this.m_istep = value;
    }

    public void setInitialLambda(double value) {
        this.m_lambda = value;
    }

    @Override
    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }
}

