/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.ibase;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.rosuda.ibase.SMarker;
import org.rosuda.ibase.SVar;
import org.rosuda.util.Global;

public class SVarSet {
    public int globalMisclassVarID = -1;
    public int globalResudialStat1ID = -1;
    public int globalResudialStat2ID = -1;
    public int classifierCounter = 1;
    public int regressionCounter = 0;
    protected List vars = new ArrayList();
    protected SMarker mark;
    protected String name = "<unknown>";

    public SMarker getMarker() {
        return this.mark;
    }

    public void setMarker(SMarker m) {
        this.mark = m;
        m.masterSet = this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public int length() {
        int len = 0;
        int l = this.vars.size();
        for (int i = 0; i < l; ++i) {
            int vl = ((SVar)this.vars.get(i)).size();
            if (vl <= len) continue;
            len = vl;
        }
        return len;
    }

    public int add(SVar v) {
        if (v == null) {
            return -1;
        }
        String nn = v.getName();
        if (nn == null) {
            return -1;
        }
        if (!this.vars.isEmpty()) {
            ListIterator e = this.vars.listIterator();
            while (e.hasNext()) {
                SVar n = (SVar)e.next();
                if (n.getName().compareTo(nn) != 0) continue;
                return -2;
            }
        }
        this.vars.add(v);
        return this.vars.indexOf(v);
    }

    public void insert(int index, SVar v) {
        this.insert("Var" + index, index, v);
    }

    public void insert(String name, int index, SVar v) {
        if (v.getName() == null) {
            v.setName(name);
        }
        this.vars.add(index, v);
    }

    public void move(int from, int to) {
        SVar v1 = (SVar)this.vars.get(from);
        this.vars.remove(from);
        this.vars.add(to, v1);
    }

    public void remove(int index) {
        this.vars.remove(index);
    }

    public boolean insertCaseAt(int index) {
        ListIterator e = this.vars.listIterator();
        while (e.hasNext()) {
            if (((SVar)e.next()).insert(null, index)) continue;
            return false;
        }
        return true;
    }

    public boolean removeCaseAt(int index) {
        ListIterator e = this.vars.listIterator();
        while (e.hasNext()) {
            SVar v = (SVar)e.next();
            if (v.remove(index)) continue;
            return false;
        }
        return true;
    }

    public int indexOf(String nam) {
        for (int i = 0; i < this.vars.size(); ++i) {
            SVar n = (SVar)this.vars.get(i);
            if (n.getName().compareTo(nam) != 0) continue;
            return i;
        }
        return -1;
    }

    public SVar byName(String nam) {
        if (this.vars.isEmpty()) {
            return null;
        }
        ListIterator e = this.vars.listIterator();
        while (e.hasNext()) {
            SVar n = (SVar)e.next();
            if (n.getName().compareTo(nam) != 0) continue;
            return n;
        }
        return null;
    }

    public SVar at(int i) {
        return i < 0 || i >= this.vars.size() ? null : (SVar)this.vars.get(i);
    }

    public void replace(int i, SVar v) {
        if (i >= 0 && i < this.vars.size()) {
            this.vars.set(i, v);
        }
    }

    public Object data(String nam, int row) {
        SVar v = this.byName(nam);
        return v == null ? null : v.elementAt(row);
    }

    public Object data(int col, int row) {
        SVar v = this.at(col);
        return v == null ? null : v.elementAt(row);
    }

    public int[] whereis(Object o, int c_off, int r_off) {
        int[] index = new int[]{-1, -1};
        for (int i = r_off; i < this.at(0).size(); ++i) {
            for (int z = c_off; z < this.vars.size(); ++z) {
                if (this.at(z).at(i) == null || this.at(z).at(i).toString().toLowerCase().indexOf(o.toString().toLowerCase()) == -1) continue;
                index[0] = z;
                index[1] = i;
                return index;
            }
            c_off = 0;
        }
        return index;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private Iterator iter;
            {
                this.iter = SVarSet.this.vars.listIterator();
            }

            public Object nextElement() {
                return this.iter.next();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }
        };
    }

    public int count() {
        return this.vars.size();
    }

    public boolean Export(PrintStream p, boolean all) {
        return this.Export(p, all, null);
    }

    public boolean Export(PrintStream p) {
        return this.Export(p, true, null);
    }

    public boolean Export(PrintStream p, boolean all, int[] vars) {
        boolean exportAll = all || this.mark == null || this.mark.marked() == 0;
        try {
            if (p != null) {
                int j = 0;
                int tcnt = 0;
                int fvar = 0;
                if (vars == null || vars.length < 1) {
                    for (j = 0; j < this.count(); ++j) {
                        p.print((tcnt == 0 ? "" : "\t") + this.at(j).getName());
                        if (tcnt == 0) {
                            fvar = j;
                        }
                        ++tcnt;
                    }
                } else {
                    while (j < vars.length) {
                        p.print((tcnt == 0 ? "" : "\t") + this.at(vars[j]).getName());
                        if (tcnt == 0) {
                            fvar = vars[j];
                        }
                        ++tcnt;
                        ++j;
                    }
                }
                p.println("");
                for (int i = 0; i < this.at(fvar).size(); ++i) {
                    Object oo;
                    if (!exportAll && !this.mark.at(i)) continue;
                    j = fvar;
                    if (vars == null || vars.length < 1) {
                        for (j = 0; j < this.count(); ++j) {
                            oo = this.at(j).at(i);
                            p.print((j == 0 ? "" : "\t") + (oo == null ? "NA" : oo.toString()));
                        }
                    } else {
                        while (j < vars.length) {
                            oo = this.at(vars[j]).at(i);
                            p.print((j == 0 ? "" : "\t") + (oo == null ? "NA" : oo.toString()));
                            ++j;
                        }
                    }
                    p.println("");
                }
            }
            return true;
        }
        catch (Exception eee) {
            if (Global.DEBUG > 0) {
                System.out.println("* SVarSet.Export...: something went wrong during the export: " + eee.getMessage());
                eee.printStackTrace();
            }
            return false;
        }
    }

    public void printSummary() {
        System.out.println("DEBUG for SVarSet [" + this.toString() + "]");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            SVar v2 = (SVar)e.nextElement();
            if (v2 == null) {
                System.out.println("Variable: null!");
                continue;
            }
            System.out.println("Variable: " + v2.getName() + " (" + (v2.isNum() ? "numeric" : "string") + "," + (v2.isCat() ? "categorized" : "free") + ") with " + v2.size() + " cases");
            if (!v2.isCat()) continue;
            Object[] c = v2.getCategories();
            System.out.print("  Categories: ");
            for (int i = 0; i < c.length; ++i) {
                System.out.print("{" + c[i].toString() + "} ");
            }
            System.out.println();
        }
    }
}

