/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.browser;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.browser.BrowserController;
import org.rosuda.JGR.browser.BrowserNode;
import org.rosuda.JGR.browser.DefaultBrowserNode;
import org.rosuda.REngine.REXP;

public class EnvironmentNode
extends DefaultBrowserNode {
    public EnvironmentNode() {
    }

    public EnvironmentNode(BrowserNode par, String rObjectName, String rClass) {
        this.parent = par;
        this.rName = rObjectName;
        this.cls = rClass;
        this.icon = this.findIcon();
    }

    @Override
    public BrowserNode generate(BrowserNode parent, String rName, String rClass) {
        return new EnvironmentNode(parent, rName, rClass);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public String getChildExecuteableRObjectName(BrowserNode child) {
        return this.getExecuteableRObjectName() + "$" + child.getRName();
    }

    @Override
    public JPopupMenu getPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        DefaultBrowserNode.PopupListener lis = new DefaultBrowserNode.PopupListener();
        JMenuItem item = new JMenuItem("Edit");
        item.addActionListener(lis);
        item = new JMenuItem("Print");
        item.addActionListener(lis);
        menu.add(item);
        item = new JMenuItem("Summary");
        item.addActionListener(lis);
        item = new JMenuItem("Plot");
        item.addActionListener(lis);
        item = new JMenuItem("Remove");
        item.addActionListener(lis);
        menu.add(item);
        return menu;
    }

    @Override
    public void update(DefaultTreeModel mod) {
        if (!this.expanded) {
            return;
        }
        try {
            REXP rexp = JGR.idleEval("ls(envir=" + this.getExecuteableRObjectName() + ")");
            if (rexp == null) {
                return;
            }
            String[] objectNames = rexp.asStrings();
            String[] objectClasses = new String[]{};
            if (objectNames.length > 0) {
                rexp = JGR.idleEval("sapply(ls(envir=" + this.getExecuteableRObjectName() + "),function(a)class(get(a,envir=" + this.getExecuteableRObjectName() + "))[1])");
                if (rexp == null) {
                    return;
                }
                objectClasses = rexp.asStrings();
            }
            if (objectNames.length < this.children.size()) {
                final String[] objNms = objectNames;
                final DefaultTreeModel m = mod;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = EnvironmentNode.this.children.size() - 1; i >= objNms.length; --i) {
                            m.removeNodeFromParent((MutableTreeNode)EnvironmentNode.this.children.get(i));
                        }
                    }
                });
            }
            int nc = Math.min(objectNames.length, BrowserController.MAX_CHILDREN);
            for (int i = 0; i < nc; ++i) {
                if (i >= objectClasses.length) continue;
                final BrowserNode node = BrowserController.createNode(this, objectNames[i], objectClasses[i]);
                if (this.children.size() > i && this.children.get(i).equals(node)) {
                    ((BrowserNode)this.children.get(i)).update(mod);
                    continue;
                }
                final Object[] tmp = this.children.toArray();
                final DefaultTreeModel m = mod;
                final int j = i;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (tmp.length > j) {
                            for (int ind = j; ind < tmp.length; ++ind) {
                                m.removeNodeFromParent((MutableTreeNode)tmp[ind]);
                            }
                        }
                        m.insertNodeInto(node, EnvironmentNode.this, EnvironmentNode.this.children.size());
                    }
                });
                node.update(m);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void editObject() {
    }

    @Override
    public void removeChildObjectFromR(BrowserNode child) {
        JGR.MAINRCONSOLE.execute("rm(\"" + child.getRName() + "\",envir=" + this.getExecuteableRObjectName() + ")");
    }

    class BlankCellRenderer
    implements TreeCellRenderer {
        JLabel lab = new JLabel();

        BlankCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return this.lab;
        }
    }
}

