/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.SelectedSparseDComplexMatrix1D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.SparseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected ConcurrentHashMap<Long, double[]> elements;

    public SparseDComplexMatrix1D(double[] dArray) {
        this(dArray.length);
        this.assign(dArray);
    }

    public SparseDComplexMatrix1D(int n) {
        this.setUp(n);
        this.elements = new ConcurrentHashMap(n / 1000);
    }

    protected SparseDComplexMatrix1D(int n, ConcurrentHashMap<Long, double[]> concurrentHashMap, int n2, int n3) {
        this.setUp(n, n2, n3);
        this.elements = concurrentHashMap;
        this.isNoView = false;
    }

    @Override
    public DComplexMatrix1D assign(double[] dArray) {
        if (this.isNoView && dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.clear();
        } else {
            super.assign(dArray);
        }
        return this;
    }

    @Override
    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    @Override
    public synchronized double[] getQuick(int n) {
        double[] dArray = this.elements.get((long)this.zero + (long)n * (long)this.stride);
        if (dArray != null) {
            return new double[]{dArray[0], dArray[1]};
        }
        return new double[2];
    }

    @Override
    public ConcurrentHashMap<Long, double[]> elements() {
        return this.elements;
    }

    @Override
    protected boolean haveSharedCellsRaw(DComplexMatrix1D dComplexMatrix1D) {
        if (dComplexMatrix1D instanceof SelectedSparseDComplexMatrix1D) {
            SelectedSparseDComplexMatrix1D selectedSparseDComplexMatrix1D = (SelectedSparseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == selectedSparseDComplexMatrix1D.elements;
        }
        if (dComplexMatrix1D instanceof SparseDComplexMatrix1D) {
            SparseDComplexMatrix1D sparseDComplexMatrix1D = (SparseDComplexMatrix1D)dComplexMatrix1D;
            return this.elements == sparseDComplexMatrix1D.elements;
        }
        return false;
    }

    @Override
    public long index(int n) {
        return (long)this.zero + (long)n * (long)this.stride;
    }

    @Override
    public DComplexMatrix1D like(int n) {
        return new SparseDComplexMatrix1D(n);
    }

    @Override
    public DComplexMatrix2D like2D(int n, int n2) {
        return new SparseDComplexMatrix2D(n, n2);
    }

    @Override
    public DComplexMatrix2D reshape(final int n, int n2) {
        if (n * n2 != this.size) {
            throw new IllegalArgumentException("rows*columns != size");
        }
        final SparseDComplexMatrix2D sparseDComplexMatrix2D = new SparseDComplexMatrix2D(n, n2);
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n3 = Math.min(n3, this.size);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = i * n4;
                final int n6 = i == n3 - 1 ? n2 : n5 + n4;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n5; i < n6; ++i) {
                            int n2 = i * n;
                            for (int j = 0; j < n; ++j) {
                                double[] dArray;
                                if ((dArray = SparseDComplexMatrix1D.this.getQuick(n2++))[0] == 0.0 && dArray[1] == 0.0) continue;
                                sparseDComplexMatrix2D.setQuick(j, i, dArray);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n7 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    double[] dArray;
                    if ((dArray = this.getQuick(n7++))[0] == 0.0 && dArray[1] == 0.0) continue;
                    ((DComplexMatrix2D)sparseDComplexMatrix2D).setQuick(j, i, dArray);
                }
            }
        }
        return sparseDComplexMatrix2D;
    }

    @Override
    public DComplexMatrix3D reshape(int n, final int n2, final int n3) {
        if (n * n2 * n3 != this.size) {
            throw new IllegalArgumentException("slices*rows*columns != size");
        }
        final SparseDComplexMatrix3D sparseDComplexMatrix3D = new SparseDComplexMatrix3D(n, n2, n3);
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n4 = Math.min(n4, this.size);
            Future[] futureArray = new Future[n4];
            int n5 = n / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n3; ++j) {
                                int n = i * n2 * n3 + j * n2;
                                for (int k = 0; k < n2; ++k) {
                                    double[] dArray;
                                    if ((dArray = SparseDComplexMatrix1D.this.getQuick(n++))[0] == 0.0 && dArray[1] == 0.0) continue;
                                    sparseDComplexMatrix3D.setQuick(i, k, j, dArray);
                                }
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n8 = 0;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n3; ++j) {
                    for (int k = 0; k < n2; ++k) {
                        double[] dArray;
                        if ((dArray = this.getQuick(n8++))[0] == 0.0 && dArray[1] == 0.0) continue;
                        ((DComplexMatrix3D)sparseDComplexMatrix3D).setQuick(i, k, j, dArray);
                    }
                }
            }
        }
        return sparseDComplexMatrix3D;
    }

    @Override
    public synchronized void setQuick(int n, double[] dArray) {
        long l = (long)this.zero + (long)n * (long)this.stride;
        if (dArray[0] == 0.0 && dArray[1] == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, dArray);
        }
    }

    @Override
    public synchronized void setQuick(int n, double d, double d2) {
        long l = (long)this.zero + (long)n * (long)this.stride;
        if (d == 0.0 && d2 == 0.0) {
            this.elements.remove(l);
        } else {
            this.elements.put(l, new double[]{d, d2});
        }
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] nArray) {
        return new SelectedSparseDComplexMatrix1D(this.elements, nArray);
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        final SparseDoubleMatrix1D sparseDoubleMatrix1D = new SparseDoubleMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            sparseDoubleMatrix1D.setQuick(i, SparseDComplexMatrix1D.this.getQuick(i)[1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                ((DoubleMatrix1D)sparseDoubleMatrix1D).setQuick(i, this.getQuick(i)[1]);
            }
        }
        return sparseDoubleMatrix1D;
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        final SparseDoubleMatrix1D sparseDoubleMatrix1D = new SparseDoubleMatrix1D(this.size);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            n = Math.min(n, this.size);
            Future[] futureArray = new Future[n];
            int n2 = this.size / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.size : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            sparseDoubleMatrix1D.setQuick(i, SparseDComplexMatrix1D.this.getQuick(i)[0]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.size; ++i) {
                ((DoubleMatrix1D)sparseDoubleMatrix1D).setQuick(i, this.getQuick(i)[0]);
            }
        }
        return sparseDoubleMatrix1D;
    }
}

