/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.amazonaws.services.kinesis.clientlibrary.exceptions.InvalidStateException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ShutdownException;
import com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorCheckpointer;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.SequenceNumberValidator;
import com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import com.amazonaws.services.kinesis.model.Record;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class RecordProcessorCheckpointer
implements IRecordProcessorCheckpointer {
    private static final Log LOG = LogFactory.getLog(RecordProcessorCheckpointer.class);
    private ICheckpoint checkpoint;
    private ExtendedSequenceNumber largestPermittedCheckpointValue;
    private ExtendedSequenceNumber lastCheckpointValue;
    private ShardInfo shardInfo;
    private SequenceNumberValidator sequenceNumberValidator;
    private ExtendedSequenceNumber sequenceNumberAtShardEnd;

    RecordProcessorCheckpointer(ShardInfo shardInfo, ICheckpoint checkpoint, SequenceNumberValidator validator) {
        this.shardInfo = shardInfo;
        this.checkpoint = checkpoint;
        this.sequenceNumberValidator = validator;
    }

    @Override
    public synchronized void checkpoint() throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Checkpointing " + this.shardInfo.getShardId() + ",  token " + this.shardInfo.getConcurrencyToken() + " at largest permitted value " + this.largestPermittedCheckpointValue));
        }
        this.advancePosition(this.largestPermittedCheckpointValue);
    }

    @Override
    public synchronized void checkpoint(Record record) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        if (record == null) {
            throw new IllegalArgumentException("Could not checkpoint a null record");
        }
        if (record instanceof UserRecord) {
            this.checkpoint(record.getSequenceNumber(), ((UserRecord)record).getSubSequenceNumber());
        } else {
            this.checkpoint(record.getSequenceNumber(), 0L);
        }
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        this.checkpoint(sequenceNumber, 0L);
    }

    @Override
    public synchronized void checkpoint(String sequenceNumber, long subSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException, IllegalArgumentException {
        ExtendedSequenceNumber newCheckpoint;
        if (subSequenceNumber < 0L) {
            throw new IllegalArgumentException("Could not checkpoint at invalid, negative subsequence number " + subSequenceNumber);
        }
        this.sequenceNumberValidator.validateSequenceNumber(sequenceNumber);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Validated checkpoint sequence number " + sequenceNumber + " for " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken()));
        }
        if (this.lastCheckpointValue.compareTo(newCheckpoint = new ExtendedSequenceNumber(sequenceNumber, subSequenceNumber)) <= 0 && newCheckpoint.compareTo(this.largestPermittedCheckpointValue) <= 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checkpointing " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " at specific extended sequence number " + newCheckpoint));
            }
        } else {
            throw new IllegalArgumentException(String.format("Could not checkpoint at extended sequence number %s as it did not fall into acceptable range between the last checkpoint %s and the greatest extended sequence number passed to this record processor %s", newCheckpoint, this.lastCheckpointValue, this.largestPermittedCheckpointValue));
        }
        this.advancePosition(newCheckpoint);
    }

    ExtendedSequenceNumber getLastCheckpointValue() {
        return this.lastCheckpointValue;
    }

    synchronized void setInitialCheckpointValue(ExtendedSequenceNumber initialCheckpoint) {
        this.lastCheckpointValue = initialCheckpoint;
    }

    synchronized ExtendedSequenceNumber getLargestPermittedCheckpointValue() {
        return this.largestPermittedCheckpointValue;
    }

    synchronized void setLargestPermittedCheckpointValue(ExtendedSequenceNumber largestPermittedCheckpointValue) {
        this.largestPermittedCheckpointValue = largestPermittedCheckpointValue;
    }

    synchronized void setSequenceNumberAtShardEnd(ExtendedSequenceNumber extendedSequenceNumber) {
        this.sequenceNumberAtShardEnd = extendedSequenceNumber;
    }

    void advancePosition(String sequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        this.advancePosition(new ExtendedSequenceNumber(sequenceNumber));
    }

    void advancePosition(ExtendedSequenceNumber extendedSequenceNumber) throws KinesisClientLibDependencyException, InvalidStateException, ThrottlingException, ShutdownException {
        ExtendedSequenceNumber checkpointToRecord = extendedSequenceNumber;
        if (this.sequenceNumberAtShardEnd != null && this.sequenceNumberAtShardEnd.equals(extendedSequenceNumber)) {
            checkpointToRecord = ExtendedSequenceNumber.SHARD_END;
        }
        if (extendedSequenceNumber != null && !extendedSequenceNumber.equals(this.lastCheckpointValue)) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Setting " + this.shardInfo.getShardId() + ", token " + this.shardInfo.getConcurrencyToken() + " checkpoint to " + checkpointToRecord));
                }
                this.checkpoint.setCheckpoint(this.shardInfo.getShardId(), checkpointToRecord, this.shardInfo.getConcurrencyToken());
                this.lastCheckpointValue = checkpointToRecord;
            }
            catch (InvalidStateException | KinesisClientLibDependencyException | ShutdownException | ThrottlingException e) {
                throw e;
            }
            catch (KinesisClientLibException e) {
                LOG.warn((Object)"Caught exception setting checkpoint.", (Throwable)e);
                throw new KinesisClientLibDependencyException("Caught exception while checkpointing", e);
            }
        }
    }
}

