/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.RegSarimaComputer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;
import jdplus.tramoseats.base.core.seats.IModelEstimator;
import jdplus.tramoseats.base.core.seats.IModelValidator;
import jdplus.tramoseats.base.core.seats.SeatsModel;

public class DefaultModelEstimator
implements IModelEstimator {
    private final IModelValidator validator;
    private final IRegArimaComputer<SarimaModel> processor;

    public DefaultModelEstimator(IModelValidator validator, IRegArimaComputer<SarimaModel> processor) {
        this.validator = validator;
        this.processor = processor == null ? RegSarimaComputer.PROCESSOR : processor;
    }

    @Override
    public boolean estimate(SeatsModel model) {
        RegArimaEstimation estimation = this.processor.process(model.asRegarima(), null);
        if (estimation == null) {
            return false;
        }
        SarimaModel arima = (SarimaModel)estimation.getModel().arima();
        if (this.validator != null && !this.validator.validate(arima)) {
            arima = this.validator.getNewModel();
        }
        model.setCurrentModel(arima);
        LikelihoodStatistics stat = estimation.statistics();
        model.setInnovationVariance(stat.getSsqErr() / (double)(stat.getEffectiveObservationsCount() - stat.getEstimatedParametersCount()));
        return true;
    }
}

