/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x13;

import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.benchmarking.SaBenchmarkingSpec;
import jdplus.sa.base.core.CholetteProcessor;
import jdplus.sa.base.core.PreliminaryChecks;
import jdplus.sa.base.core.SaBenchmarkingResults;
import jdplus.sa.base.core.modelling.RegArimaDecomposer;
import jdplus.sa.base.core.modelling.SaVariablesMapping;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.ssf.arima.ExactArimaForecasts;
import jdplus.x13.base.api.regarima.BasicSpec;
import jdplus.x13.base.api.x11.X11Spec;
import jdplus.x13.base.api.x13.X13Spec;
import jdplus.x13.base.core.x11.X11Kernel;
import jdplus.x13.base.core.x11.X11Results;
import jdplus.x13.base.core.x11.X11Utility;
import jdplus.x13.base.core.x13.X13Diagnostics;
import jdplus.x13.base.core.x13.X13Finals;
import jdplus.x13.base.core.x13.X13Preadjustment;
import jdplus.x13.base.core.x13.X13Results;
import jdplus.x13.base.core.x13.regarima.RegArimaKernel;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class X13Kernel {
    private final PreliminaryChecks.Tool preliminary;
    private final RegArimaKernel regarima;
    private final SaVariablesMapping samapping;
    private final X11Spec spec;
    private final boolean preprop;
    private final CholetteProcessor cholette;

    private static PreliminaryChecks.Tool of(X13Spec spec) {
        BasicSpec basic = spec.getRegArima().getBasic();
        return (s, logs) -> {
            TsData sc = s.select(basic.getSpan());
            if (basic.isPreliminaryCheck()) {
                PreliminaryChecks.testSeries((TsData)sc);
            }
            return sc;
        };
    }

    public static X13Kernel of(X13Spec spec, ModellingContext context) {
        PreliminaryChecks.Tool check = X13Kernel.of(spec);
        boolean blPreprop = spec.getRegArima().getBasic().isPreprocessing();
        RegArimaKernel regarima = RegArimaKernel.of(spec.getRegArima(), context);
        SaVariablesMapping mapping = new SaVariablesMapping();
        return new X13Kernel(check, regarima, mapping, spec.getX11(), blPreprop, CholetteProcessor.of((SaBenchmarkingSpec)spec.getBenchmarking()));
    }

    public X13Results process(TsData s, ProcessingLog log) {
        if (log == null) {
            log = ProcessingLog.dummy();
        }
        try {
            X13Preadjustment preadjustment;
            TsData alin;
            RegSarimaModel preprocessing;
            TsData sc = this.preliminary.check(s, log);
            if (sc == null) {
                return X13Results.builder().log(log).build();
            }
            if (this.regarima != null) {
                int nf;
                preprocessing = this.regarima.process(s, log);
                int nb = this.spec.getBackcastHorizon();
                if (nb < 0) {
                    nb = -nb * s.getAnnualFrequency();
                }
                if ((nf = this.spec.getForecastHorizon()) < 0) {
                    nf = -nf * s.getAnnualFrequency();
                }
                X13Preadjustment.Builder builder = X13Preadjustment.builder();
                alin = this.initialStep(preprocessing, nb, nf, builder);
                preadjustment = builder.build();
            } else {
                preprocessing = null;
                preadjustment = X13Preadjustment.builder().a1(sc).build();
                alin = sc;
            }
            X11Kernel x11 = new X11Kernel();
            X11Spec nspec = this.updateSpec(this.spec, preprocessing);
            X11Results xr = x11.process(alin, nspec);
            X13Finals finals = this.finals(nspec.getMode(), preadjustment, xr);
            SaBenchmarkingResults bench = null;
            if (this.cholette != null) {
                bench = this.cholette.process(s, TsData.concatenate((TsData[])new TsData[]{finals.getD11final(), finals.getD11a()}), (Explorable)preprocessing);
            }
            return X13Results.builder().preprocessing(preprocessing).preadjustment(preadjustment).decomposition(xr).finals(finals).benchmarking(bench).diagnostics(X13Diagnostics.of(preprocessing, preadjustment, xr, finals)).log(log).build();
        }
        catch (Exception err) {
            log.error(err);
            return X13Results.builder().log(log).build();
        }
    }

    private TsData initialStep(RegSarimaModel model, int nb, int nf, X13Preadjustment.Builder astep) {
        boolean mul = model.getDescription().isLogTransformation();
        TsData series = model.interpolatedSeries(false);
        TsDomain sdomain = series.getDomain();
        TsDomain domain = sdomain.extend(nb, nf);
        TsPeriod bstart = domain.getStartPeriod();
        TsPeriod fstart = sdomain.getEndPeriod();
        TsData mh = model.deterministicEffect(domain, v -> ModellingUtility.isMovingHoliday((Variable)v));
        TsData td = model.deterministicEffect(domain, v -> ModellingUtility.isDaysRelated((Variable)v));
        TsData pt = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Trend, (boolean)true, v -> ModellingUtility.isOutlier((Variable)v));
        TsData ps = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Seasonal, (boolean)true, v -> ModellingUtility.isOutlier((Variable)v));
        TsData pi = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Irregular, (boolean)true, v -> ModellingUtility.isOutlier((Variable)v));
        TsData ut = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Trend, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        TsData us = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Seasonal, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        TsData ui = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Irregular, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        TsData usa = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.SeasonallyAdjusted, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        TsData user = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Series, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        TsData uu = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.Undefined, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        TsData ucal = RegArimaDecomposer.deterministicEffect((GeneralLinearModel)model, (TsDomain)domain, (ComponentType)ComponentType.CalendarEffect, (boolean)true, v -> ModellingUtility.isUser((Variable)v));
        pt = TsData.add((TsData)pt, (TsData)ut);
        ps = TsData.add((TsData)ps, (TsData)us);
        pi = TsData.add((TsData)pi, (TsData)ui);
        TsData p = TsData.add((TsData)pt, (TsData[])new TsData[]{ps, pi});
        TsData pall = TsData.add((TsData)pt, (TsData[])new TsData[]{ps, pi});
        TsData u = TsData.add((TsData)ucal, (TsData[])new TsData[]{usa, user});
        TsData detlin = TsData.add((TsData)td, (TsData[])new TsData[]{mh, p, u});
        TsData detall = TsData.add((TsData)detlin, (TsData)uu);
        TsData nbcasts = null;
        TsData nfcasts = null;
        TsData s = model.interpolatedSeries(true);
        if (nb > 0 || nf > 0) {
            DoubleSeq tmp;
            TsData lin = TsData.subtract((TsData)s, (TsData)detall);
            SarimaModel arima = model.arima();
            ExactArimaForecasts fcasts = new ExactArimaForecasts();
            boolean mean = model.isMeanCorrection();
            fcasts.prepare((IArimaModel)arima, mean);
            if (nb > 0) {
                tmp = fcasts.backcasts(lin.getValues(), nb);
                nbcasts = TsData.of((TsPeriod)bstart, (DoubleSeq)tmp);
                nbcasts = TsData.add((TsData)nbcasts, (TsData)detall);
            }
            if (nf > 0) {
                tmp = fcasts.forecasts(lin.getValues(), nf);
                nfcasts = TsData.of((TsPeriod)fstart, (DoubleSeq)tmp);
                nfcasts = TsData.add((TsData)nfcasts, (TsData)detall);
            }
        }
        TsData a1a = nfcasts == null ? null : model.backTransform(nfcasts, true);
        TsData a1b = nbcasts == null ? null : model.backTransform(nbcasts, true);
        astep.a1(series).a1a(a1a).a1b(a1b).a6(model.backTransform(td, true)).a7(model.backTransform(mh, false)).a8(model.backTransform(pall, false)).a8t(model.backTransform(pt, false)).a8s(model.backTransform(ps, false)).a8i(model.backTransform(pi, false)).a9(model.backTransform(u, false)).a9u(model.backTransform(uu, false)).a9cal(model.backTransform(ucal, false)).a9sa(model.backTransform(usa, false)).a9ser(model.backTransform(user, false));
        series = TsData.concatenate((TsData[])new TsData[]{a1b, series, a1a});
        TsData x = model.backTransform(detlin, true);
        return mul ? TsData.divide((TsData)series, (TsData)x) : TsData.subtract((TsData)series, (TsData)x);
    }

    private X11Spec updateSpec(X11Spec spec, RegSarimaModel model) {
        if (model == null) {
            return spec;
        }
        int nb = spec.getBackcastHorizon();
        int nf = spec.getForecastHorizon();
        int period = model.getAnnualFrequency();
        X11Spec.Builder builder = spec.toBuilder().backcastHorizon(nb < 0 ? -nb * period : nb).forecastHorizon(nf < 0 ? -nf * period : nf);
        if (!this.preprop) {
            builder.mode(spec.getMode() == DecompositionMode.Undefined ? DecompositionMode.Additive : spec.getMode());
            return (X11Spec)builder.build();
        }
        if (spec.getMode() != DecompositionMode.PseudoAdditive) {
            boolean mul = model.getDescription().isLogTransformation();
            if (mul) {
                if (spec.getMode() != DecompositionMode.Multiplicative && spec.getMode() != DecompositionMode.LogAdditive) {
                    builder.mode(DecompositionMode.Multiplicative);
                }
            } else {
                builder.mode(DecompositionMode.Additive);
            }
        }
        return (X11Spec)builder.build();
    }

    private TsData op(DecompositionMode mode, TsData l, TsData r) {
        if (mode != DecompositionMode.Multiplicative && mode != DecompositionMode.PseudoAdditive) {
            return TsData.subtract((TsData)l, (TsData)r);
        }
        return TsData.divide((TsData)l, (TsData)r);
    }

    private TsData invOp(DecompositionMode mode, TsData l, TsData r) {
        if (!mode.isMultiplicative() && mode != DecompositionMode.PseudoAdditive) {
            return TsData.add((TsData)l, (TsData)r);
        }
        return TsData.multiply((TsData)l, (TsData[])new TsData[]{r});
    }

    private double mean(DecompositionMode mode) {
        if (!mode.isMultiplicative() && mode != DecompositionMode.PseudoAdditive) {
            return 0.0;
        }
        return 1.0;
    }

    private TsData correct(TsData s, TsData weights, TsData rs) {
        DoubleSeq sc = X11Utility.correctSeries(s.getValues(), weights.getValues(), rs.getValues());
        return TsData.of((TsPeriod)s.getStart(), (DoubleSeq)sc.commit());
    }

    private TsData correct(TsData s, TsData weights, double mean) {
        DoubleSeq sc = X11Utility.correctSeries(s.getValues(), weights.getValues(), mean);
        return TsData.of((TsPeriod)s.getStart(), (DoubleSeq)sc.commit());
    }

    private X13Finals finals(DecompositionMode mode, X13Preadjustment astep, X11Results x11) {
        TsData a1 = astep.getA1();
        TsData a1a = astep.getA1a();
        TsData a1b = astep.getA1b();
        TsData a8t = astep.getA8t();
        TsData a8i = astep.getA8i();
        TsData a8s = astep.getA8s();
        TsData d10 = x11.getD10();
        TsData d11 = x11.getD11();
        TsData d12 = x11.getD12();
        TsData d13 = x11.getD13();
        X13Finals.Builder decomp = X13Finals.builder();
        TsDomain bd = a1b == null ? null : a1b.getDomain();
        TsDomain fd = a1a == null ? null : a1a.getDomain();
        TsDomain d = a1.getDomain();
        TsData a6 = astep.getA6();
        TsData a7 = astep.getA7();
        TsData a9cal = astep.getA9cal();
        TsData d18 = this.invOp(mode, a6, a7);
        d18 = this.invOp(mode, d18, a9cal);
        TsData d10c = this.invOp(mode, d10, a8s);
        TsData d16 = this.invOp(mode, d10c, d18);
        TsData d11c = this.invOp(mode, d11, a8t);
        d11c = this.invOp(mode, d11c, a8i);
        TsData a9sa = astep.getA9sa();
        d11c = this.invOp(mode, d11c, a9sa);
        TsData d12c = this.invOp(mode, d12, a8t);
        TsData d13c = this.invOp(mode, d13, a8i);
        if (fd != null) {
            decomp.d11a(TsData.fitToDomain((TsData)d11c, (TsDomain)fd));
            decomp.d12a(TsData.fitToDomain((TsData)d12c, (TsDomain)fd));
            decomp.d16a(TsData.fitToDomain((TsData)d16, (TsDomain)fd));
            decomp.d18a(TsData.fitToDomain((TsData)d18, (TsDomain)fd));
        }
        if (bd != null) {
            decomp.d11b(TsData.fitToDomain((TsData)d11c, (TsDomain)bd));
            decomp.d12b(TsData.fitToDomain((TsData)d12c, (TsDomain)bd));
            decomp.d16b(TsData.fitToDomain((TsData)d16, (TsDomain)bd));
            decomp.d18b(TsData.fitToDomain((TsData)d18, (TsDomain)bd));
        }
        d11c = TsData.fitToDomain((TsData)d11c, (TsDomain)d);
        d12c = TsData.fitToDomain((TsData)d12c, (TsDomain)d);
        d16 = TsData.fitToDomain((TsData)d16, (TsDomain)d);
        d18 = TsData.fitToDomain((TsData)d18, (TsDomain)d);
        d13c = TsData.fitToDomain((TsData)d13c, (TsDomain)d);
        decomp.d11final(d11c);
        decomp.d12final(d12c);
        decomp.d13final(d13c);
        decomp.d16(d16);
        decomp.d18(d18);
        TsData a1c = this.op(mode, a1, a8i);
        d11c = this.op(mode, d11c, a8i);
        TsData c17 = TsData.fitToDomain((TsData)x11.getC17(), (TsDomain)d);
        TsData tmp = this.op(mode, a1, d13c);
        TsData e1 = this.correct(a1c, c17, tmp);
        TsData e2 = this.correct(d11c, c17, d12);
        TsData e3 = this.correct(TsData.fitToDomain((TsData)d13, (TsDomain)d), c17, this.mean(mode));
        TsData e11 = this.correct(d11c, c17, this.invOp(mode, d12, this.op(mode, a1c, e1)));
        decomp.e1(e1);
        decomp.e2(e2);
        decomp.e3(e3);
        decomp.e11(e11);
        return decomp.build();
    }

    @Generated
    public X13Kernel(PreliminaryChecks.Tool preliminary, RegArimaKernel regarima, SaVariablesMapping samapping, X11Spec spec, boolean preprop, CholetteProcessor cholette) {
        this.preliminary = preliminary;
        this.regarima = regarima;
        this.samapping = samapping;
        this.spec = spec;
        this.preprop = preprop;
        this.cholette = cholette;
    }

    @Generated
    public PreliminaryChecks.Tool getPreliminary() {
        return this.preliminary;
    }

    @Generated
    public RegArimaKernel getRegarima() {
        return this.regarima;
    }

    @Generated
    public SaVariablesMapping getSamapping() {
        return this.samapping;
    }

    @Generated
    public X11Spec getSpec() {
        return this.spec;
    }

    @Generated
    public boolean isPreprop() {
        return this.preprop;
    }

    @Generated
    public CholetteProcessor getCholette() {
        return this.cholette;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X13Kernel)) {
            return false;
        }
        X13Kernel other = (X13Kernel)o;
        if (this.isPreprop() != other.isPreprop()) {
            return false;
        }
        PreliminaryChecks.Tool this$preliminary = this.getPreliminary();
        PreliminaryChecks.Tool other$preliminary = other.getPreliminary();
        if (this$preliminary == null ? other$preliminary != null : !this$preliminary.equals(other$preliminary)) {
            return false;
        }
        RegArimaKernel this$regarima = this.getRegarima();
        RegArimaKernel other$regarima = other.getRegarima();
        if (this$regarima == null ? other$regarima != null : !this$regarima.equals(other$regarima)) {
            return false;
        }
        SaVariablesMapping this$samapping = this.getSamapping();
        SaVariablesMapping other$samapping = other.getSamapping();
        if (this$samapping == null ? other$samapping != null : !this$samapping.equals(other$samapping)) {
            return false;
        }
        X11Spec this$spec = this.getSpec();
        X11Spec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !this$spec.equals(other$spec)) {
            return false;
        }
        CholetteProcessor this$cholette = this.getCholette();
        CholetteProcessor other$cholette = other.getCholette();
        return !(this$cholette == null ? other$cholette != null : !this$cholette.equals(other$cholette));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreprop() ? 79 : 97);
        PreliminaryChecks.Tool $preliminary = this.getPreliminary();
        result = result * 59 + ($preliminary == null ? 43 : $preliminary.hashCode());
        RegArimaKernel $regarima = this.getRegarima();
        result = result * 59 + ($regarima == null ? 43 : $regarima.hashCode());
        SaVariablesMapping $samapping = this.getSamapping();
        result = result * 59 + ($samapping == null ? 43 : $samapping.hashCode());
        X11Spec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : $spec.hashCode());
        CholetteProcessor $cholette = this.getCholette();
        result = result * 59 + ($cholette == null ? 43 : $cholette.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "X13Kernel(preliminary=" + String.valueOf(this.getPreliminary()) + ", regarima=" + String.valueOf(this.getRegarima()) + ", samapping=" + String.valueOf(this.getSamapping()) + ", spec=" + String.valueOf(this.getSpec()) + ", preprop=" + this.isPreprop() + ", cholette=" + String.valueOf(this.getCholette()) + ")";
    }
}

