/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.random;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.random.RandomGenerator;

public abstract class BitsStreamGenerator
implements RandomGenerator {
    private double nextGaussian = Double.NaN;

    public abstract void setSeed(int var1);

    public abstract void setSeed(int[] var1);

    public abstract void setSeed(long var1);

    protected abstract int next(int var1);

    public boolean nextBoolean() {
        return this.next(1) != 0;
    }

    public void nextBytes(byte[] bytes) {
        int random;
        int i;
        int iEnd = bytes.length - 3;
        for (i = 0; i < iEnd; i += 4) {
            random = this.next(32);
            bytes[i] = (byte)(random & 0xFF);
            bytes[i + 1] = (byte)(random >> 8 & 0xFF);
            bytes[i + 2] = (byte)(random >> 16 & 0xFF);
            bytes[i + 3] = (byte)(random >> 24 & 0xFF);
        }
        random = this.next(32);
        while (i < bytes.length) {
            bytes[i++] = (byte)(random & 0xFF);
            random >>= 8;
        }
    }

    public double nextDouble() {
        long high = (long)this.next(26) << 26;
        int low = this.next(26);
        return (double)(high | (long)low) * 2.220446049250313E-16;
    }

    public float nextFloat() {
        return (float)this.next(23) * 1.1920929E-7f;
    }

    public double nextGaussian() {
        double random;
        if (Double.isNaN(this.nextGaussian)) {
            double x = this.nextDouble();
            double y = this.nextDouble();
            double alpha = Math.PI * 2 * x;
            double r = Math.sqrt(-2.0 * Math.log(y));
            random = r * Math.cos(alpha);
            this.nextGaussian = r * Math.sin(alpha);
        } else {
            random = this.nextGaussian;
            this.nextGaussian = Double.NaN;
        }
        return random;
    }

    public int nextInt() {
        return this.next(32);
    }

    public int nextInt(int n) throws IllegalArgumentException {
        int random;
        if (n < 1) {
            throw MathRuntimeException.createIllegalArgumentException("upper bound must be positive ({0})", n);
        }
        int mask = n;
        mask |= mask >> 1;
        mask |= mask >> 2;
        mask |= mask >> 4;
        mask |= mask >> 8;
        mask |= mask >> 16;
        while ((random = this.next(32) & mask) >= n) {
        }
        return random;
    }

    public long nextLong() {
        long high = (long)this.next(32) << 32;
        long low = (long)this.next(32) & 0xFFFFFFFFL;
        return high | low;
    }
}

