/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.tramoseats.base.core.tramo.ModelComparator;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.ModelVerifier;
import jdplus.tramoseats.base.core.tramo.TramoContext;

class ModelBenchmarking
extends ModelController {
    public static final String BENCH = "model benchmarking";
    public static final String AIRLINE = "airline model finally selected";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        SarimaOrders spec = modelling.getDescription().specification();
        if (spec.isAirline(context.seasonal)) {
            return ProcessingResult.Unchanged;
        }
        ProcessingLog log = modelling.getLog();
        try {
            log.push(BENCH);
            ModelVerifier verifier = new ModelVerifier();
            if (verifier.accept(modelling)) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)modelling.getDescription());
            ndesc.setAirline(context.seasonal);
            ndesc.setMean(context.seasonal ? modelling.getDescription().isMean() : true);
            ndesc.removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
            RegSarimaModelling nmodelling = RegSarimaModelling.of((ModelDescription)ndesc);
            if (!this.estimate(nmodelling, true)) {
                ProcessingResult processingResult = ProcessingResult.Failed;
                return processingResult;
            }
            ModelComparator mcmp = ModelComparator.builder().build();
            int cmp = mcmp.compare(modelling, nmodelling);
            if (cmp < 1) {
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            this.transferInformation(nmodelling, modelling);
            modelling.getLog().remark(AIRLINE);
            ProcessingResult processingResult = ProcessingResult.Changed;
            return processingResult;
        }
        finally {
            log.pop();
        }
    }
}

