/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TIntHashSetDecorator
extends AbstractSet<Integer>
implements Set<Integer>,
Externalizable {
    protected TIntHashSet _set;

    public TIntHashSetDecorator() {
    }

    public TIntHashSetDecorator(TIntHashSet set) {
        this._set = set;
    }

    public TIntHashSet getSet() {
        return this._set;
    }

    public TIntHashSetDecorator clone() {
        try {
            TIntHashSetDecorator copy = (TIntHashSetDecorator)super.clone();
            copy._set = (TIntHashSet)this._set.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public boolean add(Integer value) {
        return this._set.add(this.unwrap(value));
    }

    @Override
    public boolean equals(Object other) {
        if (this._set.equals(other)) {
            return true;
        }
        if (other instanceof Set) {
            Set that = (Set)other;
            if (that.size() != this._set.size()) {
                return false;
            }
            Iterator it = that.iterator();
            int i = that.size();
            while (i-- > 0) {
                Object val = it.next();
                if (val instanceof Integer) {
                    int v = this.unwrap(val);
                    if (this._set.contains(v)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean remove(Object value) {
        return this._set.remove(this.unwrap(value));
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private final TIntIterator it;
            {
                this.it = TIntHashSetDecorator.this._set.iterator();
            }

            @Override
            public Integer next() {
                return TIntHashSetDecorator.this.wrap(this.it.next());
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        };
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected Integer wrap(int k) {
        return k;
    }

    protected int unwrap(Object value) {
        return (Integer)value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        this._set = (TIntHashSet)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        out.writeObject(this._set);
    }
}

