# This file is encoded in Shift_JIS.
die "This file is not encoded in Shift_JIS.\n" if '' ne "\x82\xA0";
die "This script is for perl only. You are using $^X.\n" if $^X =~ /jperl/i;

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";
use mb;
mb::set_script_encoding('sjis');
use vars qw(@test);

use vars qw($MSWin32_MBCS);
$MSWin32_MBCS = ($^O =~ /MSWin32/) and (qx{chcp} =~ m/[^0123456789](932|936|949|950|951|20932|54936)\Z/);

BEGIN {
    $SIG{__WARN__} = sub {
        local($_) = @_;
        /\Asubstr outside of string at /   ? return :
        /\AUse of uninitialized value at / ? return :
        warn $_[0];
    };
}

@test = (
# 1
    sub {                         $_='0123456789'; my $r=    substr($_,-11, 1,'abc'); $r eq ''         },
    sub { ($] > 5.005) or eval q{ $_='0123456789'; my $r=    substr($_, 12, 1,'abc'); $r eq ''        }},
    sub {                         $_='0123456789'; my $r=mb::substr($_,-11, 1,'abc'); not defined($r)  },
    sub {                         $_='0123456789'; my $r=mb::substr($_, 12, 1,'abc'); not defined($r)  },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 11
    sub { $_='0123456789';    my $r=    substr($_, 3, 2,'abc');       $_ eq '012abc56789'      },
    sub { $_='0123456789';    my $r=    substr($_, 3, 2,'abc');       $r eq '34'               },
    sub { $_='0123456789';    my $r=mb::substr($_, 3, 2,'abc');       $_ eq '012abc56789'      },
    sub { $_='0123456789';    my $r=mb::substr($_, 3, 2,'abc');       $r eq '34'               },
    sub { $_='01abc'; my $r=mb::substr($_, 3, 5,'DE2'); $_ eq '0DE2' },
    sub { $_='01abc'; my $r=mb::substr($_, 3, 5,'DE2'); $r eq '1abc'           },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 21
    sub { $_='0123456789';    my $r=    substr($_, -4, 2,'abc');       $_ eq '012345abc89'       },
    sub { $_='0123456789';    my $r=    substr($_, -4, 2,'abc');       $r eq '67'                },
    sub { $_='0123456789';    my $r=mb::substr($_, -4, 2,'abc');       $_ eq '012345abc89'       },
    sub { $_='0123456789';    my $r=mb::substr($_, -4, 2,'abc');       $r eq '67'                },
    sub { $_='01abc'; my $r=mb::substr($_, -5, 4,'DE2'); $_ eq '01DE2' },
    sub { $_='01abc'; my $r=mb::substr($_, -5, 4,'DE2'); $r eq 'abc'             },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 31
    sub { $_='0123456789';    my $r=    substr($_, 1, -5,'abc');       $_ eq '0abc56789'          },
    sub { $_='0123456789';    my $r=    substr($_, 1, -5,'abc');       $r eq '1234'               },
    sub { $_='0123456789';    my $r=mb::substr($_, 1, -5,'abc');       $_ eq '0abc56789'          },
    sub { $_='0123456789';    my $r=mb::substr($_, 1, -5,'abc');       $r eq '1234'               },
    sub { $_='01abc'; my $r=mb::substr($_, 1, -5,'DE2'); $_ eq 'DE2abc' },
    sub { $_='01abc'; my $r=mb::substr($_, 1, -5,'DE2'); $r eq '01'               },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 41
    sub { $_='0123456789';    my $r=    substr($_, -5, -2,'abc');       $_ eq '01234abc89'          },
    sub { $_='0123456789';    my $r=    substr($_, -5, -2,'abc');       $r eq '567'                 },
    sub { $_='0123456789';    my $r=mb::substr($_, -5, -2,'abc');       $_ eq '01234abc89'          },
    sub { $_='0123456789';    my $r=mb::substr($_, -5, -2,'abc');       $r eq '567'                 },
    sub { $_='01abc'; my $r=mb::substr($_, -6, -3,'DE2'); $_ eq '0DE2c' },
    sub { $_='01abc'; my $r=mb::substr($_, -6, -3,'DE2'); $r eq '1ab'                 },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 51
    sub { $_='0123456789';    my $r=    substr($_, 3, 2); $r eq '34'     },
    sub { $_='0123456789';    my $r=mb::substr($_, 3, 2); $r eq '34'     },
    sub { $_='01abc'; my $r=mb::substr($_, 3, 5); $r eq '1abc' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 61
    sub { $_='0123456789';    my $r=    substr($_, -4, 2); $r eq '67'    },
    sub { $_='0123456789';    my $r=mb::substr($_, -4, 2); $r eq '67'    },
    sub { $_='01abc'; my $r=mb::substr($_, -5, 4); $r eq 'abc' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 71
    sub { $_='0123456789';    my $r=    substr($_, 1, -5); $r eq '1234' },
    sub { $_='0123456789';    my $r=mb::substr($_, 1, -5); $r eq '1234' },
    sub { $_='01abc'; my $r=mb::substr($_, 1, -5); $r eq '01' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 81
    sub { $_='0123456789';    my $r=    substr($_, -5, -2); $r eq '567' },
    sub { $_='0123456789';    my $r=mb::substr($_, -5, -2); $r eq '567' },
    sub { $_='01abc'; my $r=mb::substr($_, -6, -3); $r eq '1ab' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 91
    sub { $_='0123456789';    my $r=    substr($_, 3); $r eq '3456789'  },
    sub { $_='0123456789';    my $r=mb::substr($_, 3); $r eq '3456789'  },
    sub { $_='01abc'; my $r=mb::substr($_, 3); $r eq '1abc' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 101
    sub { $_='0123456789';    my $r=    substr($_, -4); $r eq '6789'    },
    sub { $_='0123456789';    my $r=mb::substr($_, -4); $r eq '6789'    },
    sub { $_='01abc'; my $r=mb::substr($_, -5); $r eq 'abc' },
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 111
    sub { ($] < 5.014) or eval q{ $_='0123456789';        substr($_, 3, 2)='67d'; $_ eq '01267d56789' }},
    sub { ($] < 5.014) or eval q{ $_='0123456789';    mb::substr($_, 3, 2)='67d'; $_ eq '01267d56789' }},
    sub { ($] < 5.014) or eval q{ $_='01abc'; mb::substr($_, 3, 5)='67d'; $_ eq '067d'  }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 121
    sub { ($] < 5.014) or eval q{ $_='0123456789';        substr($_, -4, 2)='67d'; $_ eq '01234567d89' }},
    sub { ($] < 5.014) or eval q{ $_='0123456789';    mb::substr($_, -4, 2)='67d'; $_ eq '01234567d89' }},
    sub { ($] < 5.014) or eval q{ $_='01abc'; mb::substr($_, -5, 4)='67d'; $_ eq '0167d' }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 131
    sub { ($] < 5.014) or eval q{ $_='0123456789';        substr($_, 1, -5)='67d'; $_ eq '067d56789'    }},
    sub { ($] < 5.014) or eval q{ $_='0123456789';    mb::substr($_, 1, -5)='67d'; $_ eq '067d56789'    }},
    sub { ($] < 5.014) or eval q{ $_='01abc'; mb::substr($_, 1, -5)='67d'; $_ eq '67dabc' }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 141
    sub { ($] < 5.014) or eval q{ $_='0123456789';        substr($_, -5, -2)='67d'; $_ eq '0123467d89'    }},
    sub { ($] < 5.014) or eval q{ $_='0123456789';    mb::substr($_, -5, -2)='67d'; $_ eq '0123467d89'    }},
    sub { ($] < 5.014) or eval q{ $_='01abc'; mb::substr($_, -6, -3)='67d'; $_ eq '067dc' }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 151
    sub { ($] < 5.014) or eval q{ $_='0123456789';        substr($_, 3)='ef9'; $_ eq '012ef9'   }},
    sub { ($] < 5.014) or eval q{ $_='0123456789';    mb::substr($_, 3)='ef9'; $_ eq '012ef9'   }},
    sub { ($] < 5.014) or eval q{ $_='01abc'; mb::substr($_, 3)='ef9'; $_ eq '0ef9' }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
# 161
    sub { ($] < 5.014) or eval q{ $_='0123456789';        substr($_, -4)='ef9'; $_ eq '012345ef9' }},
    sub { ($] < 5.014) or eval q{ $_='0123456789';    mb::substr($_, -4)='ef9'; $_ eq '012345ef9' }},
    sub { ($] < 5.014) or eval q{ $_='01abc'; mb::substr($_, -5)='ef9'; $_ eq '01ef9' }},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
    sub {1},
#
);

$|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" } ok($_->()) for @test;

__END__
