{- This module was generated from data in the Kate syntax
   highlighting file xml.xml, version 2.03, by Wilbert Berendsen (wilbert@kde.nl) -}

module Text.Highlighting.Kate.Syntax.Xml
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)

-- | Full name of language.
syntaxName :: String
syntaxName = "XML"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.docbook;*.xml;*.rc;*.daml;*.rdf;*.rss;*.xspf;*.xsd;*.svg;*.ui;*.kcfg;*.qrc;*.wsdl"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "XML" }
  context <- currentContext <|> (pushContext "Start" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("XML",["Start"])], synStLanguage = "XML", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Start" -> return ()
    "FindXML" -> return ()
    "FindEntityRefs" -> return ()
    "FindPEntityRefs" -> return ()
    "Comment" -> return ()
    "CDATA" -> return ()
    "PI" -> return ()
    "Doctype" -> return ()
    "Doctype Internal Subset" -> return ()
    "Doctype Markupdecl" -> return ()
    "Doctype Markupdecl DQ" -> return ()
    "Doctype Markupdecl SQ" -> return ()
    "Element" -> return ()
    "El Content" -> return ()
    "El End" -> return ()
    "Attribute" -> return ()
    "Value" -> return ()
    "Value DQ" -> return ()
    "Value SQ" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))


regex_'3c'21DOCTYPE'5cs'2b = compileRegex "<!DOCTYPE\\s+"
regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a = compileRegex "<\\?[\\w:_-]*"
regex_'3c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "<(?![0-9])[\\w_:][\\w.:_-]*"
regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b = compileRegex "&(#[0-9]+|#[xX][0-9A-Fa-f]+|(?![0-9])[\\w_:][\\w.:_-]*);"
regex_'25'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b = compileRegex "%(?![0-9])[\\w_:][\\w.:_-]*;"
regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b = compileRegex "-(-(?!->))+"
regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb = compileRegex "<!(ELEMENT|ENTITY|ATTLIST|NOTATION)\\b"
regex_'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5cs'2b'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "\\s+(?![0-9])[\\w_:][\\w.:_-]*"
regex_'5cS = compileRegex "\\S"
regex_'3c'2f'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a = compileRegex "</(?![0-9])[\\w_:][\\w.:_-]*"

defaultAttributes = [("Start",NormalTok),("FindXML",NormalTok),("FindEntityRefs",NormalTok),("FindPEntityRefs",NormalTok),("Comment",CommentTok),("CDATA",NormalTok),("PI",NormalTok),("Doctype",NormalTok),("Doctype Internal Subset",NormalTok),("Doctype Markupdecl",NormalTok),("Doctype Markupdecl DQ",StringTok),("Doctype Markupdecl SQ",StringTok),("Element",NormalTok),("El Content",NormalTok),("El End",NormalTok),("Attribute",NormalTok),("Value",NormalTok),("Value DQ",StringTok),("Value SQ",StringTok)]

parseRules "Start" =
  ((parseRules "FindXML"))

parseRules "FindXML" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pString False "<![CDATA[" >>= withAttribute BaseNTok) >>~ pushContext "CDATA")
   <|>
   ((pRegExpr regex_'3c'21DOCTYPE'5cs'2b >>= withAttribute DataTypeTok) >>~ pushContext "Doctype")
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "PI")
   <|>
   ((pRegExpr regex_'3c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "Element")
   <|>
   ((parseRules "FindEntityRefs"))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok)))

parseRules "FindEntityRefs" =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&<" >>= withAttribute ErrorTok)))

parseRules "FindPEntityRefs" =
  (((pRegExpr regex_'26'28'23'5b0'2d9'5d'2b'7c'23'5bxX'5d'5b0'2d9A'2dFa'2df'5d'2b'7c'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'29'3b >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'25'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a'3b >>= withAttribute DecValTok))
   <|>
   ((pAnyChar "&%" >>= withAttribute ErrorTok)))

parseRules "Comment" =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pString False "-->" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'2d'28'2d'28'3f'21'2d'3e'29'29'2b >>= withAttribute ErrorTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok)))

parseRules "CDATA" =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pString False "]]>" >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((pString False "]]&gt;" >>= withAttribute DecValTok)))

parseRules "PI" =
  ((pDetect2Chars False '?' '>' >>= withAttribute KeywordTok) >>~ (popContext))

parseRules "Doctype" =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '[' >>= withAttribute DataTypeTok) >>~ pushContext "Doctype Internal Subset"))

parseRules "Doctype Internal Subset" =
  (((pDetectChar False ']' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'3c'21'28ELEMENT'7cENTITY'7cATTLIST'7cNOTATION'29'5cb >>= withAttribute DataTypeTok) >>~ pushContext "Doctype Markupdecl")
   <|>
   ((pString False "<!--" >>= withAttribute CommentTok) >>~ pushContext "Comment")
   <|>
   ((pRegExpr regex_'3c'5c'3f'5b'5cw'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "PI")
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Doctype Markupdecl" =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Doctype Markupdecl DQ")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Doctype Markupdecl SQ"))

parseRules "Doctype Markupdecl DQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Doctype Markupdecl SQ" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   ((parseRules "FindPEntityRefs")))

parseRules "Element" =
  (((pDetect2Chars False '/' '>' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ pushContext "El Content")
   <|>
   ((pColumn 0 >> pRegExpr regex_'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext "Attribute")
   <|>
   ((pRegExpr regex_'5cs'2b'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute OtherTok) >>~ pushContext "Attribute")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "El Content" =
  (((pRegExpr regex_'3c'2f'28'3f'21'5b0'2d9'5d'29'5b'5cw'5f'3a'5d'5b'5cw'2e'3a'5f'2d'5d'2a >>= withAttribute KeywordTok) >>~ pushContext "El End")
   <|>
   ((parseRules "FindXML")))

parseRules "El End" =
  (((pDetectChar False '>' >>= withAttribute KeywordTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "Attribute" =
  (((pDetectChar False '=' >>= withAttribute OtherTok) >>~ pushContext "Value")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "Value" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Value DQ")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Value SQ")
   <|>
   ((pRegExpr regex_'5cS >>= withAttribute ErrorTok)))

parseRules "Value DQ" =
  (((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "Value SQ" =
  (((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((parseRules "FindEntityRefs")))

parseRules "" = parseRules "Start"

parseRules x = fail $ "Unknown context" ++ x
