{- This module was generated from data in the Kate syntax
   highlighting file objectivec.xml, version 1.07, by  -}

module Text.Highlighting.Kate.Syntax.Objectivec
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Objective-C"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.m;*.h"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Objective-C" }
  context <- currentContext <|> (pushContext "Default" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Objective-C",["Default"])], synStLanguage = "Objective-C", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Default" -> return ()
    "String" -> (popContext) >> pEndLine
    "SingleLineComment" -> (popContext) >> pEndLine
    "MultiLineComment" -> return ()
    "Preprocessor" -> pushContext "Default" >> return ()
    "MultiLineCommentPrep" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "break case continue default do else enum extern for goto if return sizeof struct switch typedef union while @class @defs @encode @end @implementation @interface @private @protected @protocol @public @selector self super"
list_types = Set.fromList $ words $ "auto char const double float int long register short signed static unsigned void volatile"

regex_'23 = compileRegex "#"

defaultAttributes = [("Default",NormalTok),("String",StringTok),("SingleLineComment",CommentTok),("MultiLineComment",CommentTok),("Preprocessor",OtherTok),("MultiLineCommentPrep",CommentTok)]

parseRules "Default" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "String")
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "SingleLineComment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "MultiLineComment")
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'23 >>= withAttribute OtherTok) >>~ pushContext "Preprocessor")
   <|>
   ((pDetect2Chars False '@' '"' >>= withAttribute StringTok) >>~ pushContext "String"))

parseRules "String" =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "SingleLineComment" =
  pzero

parseRules "MultiLineComment" =
  ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))

parseRules "Preprocessor" =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression >>= ((withAttribute OtherTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "SingleLineComment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "MultiLineCommentPrep"))

parseRules "MultiLineCommentPrep" =
  ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext))

parseRules "" = parseRules "Default"

parseRules x = fail $ "Unknown context" ++ x
