/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.jive.sheet;

import org.dbdoclet.unit.Length;

public class Padding extends Bound {

	public Padding() {
		super();
	}

	public Padding(Length top, Length right, Length bottom, Length left) {
		super(top, right, bottom, left);
	}

	public Padding deepCopy() {
	
		Padding copy = new Padding();
		copy.setTop(getTop().deepCopy());
		copy.setRight(getRight().deepCopy());
		copy.setBottom(getBottom().deepCopy());
		copy.setLeft(getLeft().deepCopy());
		return copy;
	}
	
	@Override
	public String toString() {
		return "Padding [top=" + getTop() + ", right=" + getRight() + ", bottom=" + getBottom()
				+ ", left=" + getLeft() + "]";
	}

}
