import System.Environment
import System.IO

import Arsec
import CaseFolding
import SpecialCasing

main = do
  args <- getArgs
  let oname = case args of
                [] -> "../Data/Text/Fusion/CaseMapping.hs"
                [o] -> o
  psc <- parseSC "SpecialCasing.txt"
  pcf <- parseCF "CaseFolding.txt"
  scs <- case psc of
           Left err -> print err >> return undefined
           Right ms -> return ms
  cfs <- case pcf of
           Left err -> print err >> return undefined
           Right ms -> return ms
  h <- openFile oname WriteMode
  mapM_ (hPutStrLn h) ["{-# LANGUAGE Rank2Types #-}"
                      ,"-- AUTOMATICALLY GENERATED - DO NOT EDIT"
                      ,"-- Generated by scripts/SpecialCasing.hs"
                      ,"module Data.Text.Fusion.CaseMapping where"
                      ,"import Data.Char"
                      ,"import Data.Text.Fusion.Internal"
                      ,""]
  mapM_ (hPutStrLn h) (mapSC "upper" upper toUpper scs)
  mapM_ (hPutStrLn h) (mapSC "lower" lower toLower scs)
  mapM_ (hPutStrLn h) (mapCF cfs)
  hClose h
