{-# OPTIONS_GHC -w #-}
-- We use these options because Happy generates code with a lot of warnings.
{-# LANGUAGE Trustworthy #-}
module Text.Show.Parser (parseValue) where

import Text.Show.Value
import Language.Haskell.Lexer
import Control.Applicative(Applicative(..))
import Control.Monad (ap)

-- parser produced by Happy Version 1.19.5

data HappyAbsSyn t12 t13 t14 t15 t16 t17 t18 t19 t20 t21 t22 t23 t24 t25 t26 t27 t28 t29 t30 t31
	= HappyTerminal (PosToken)
	| HappyErrorToken Int
	| HappyAbsSyn4 (Value)
	| HappyAbsSyn5 ((String,Value))
	| HappyAbsSyn8 (String)
	| HappyAbsSyn10 ((Name,Value))
	| HappyAbsSyn11 ([Value])
	| HappyAbsSyn12 t12
	| HappyAbsSyn13 t13
	| HappyAbsSyn14 t14
	| HappyAbsSyn15 t15
	| HappyAbsSyn16 t16
	| HappyAbsSyn17 t17
	| HappyAbsSyn18 t18
	| HappyAbsSyn19 t19
	| HappyAbsSyn20 t20
	| HappyAbsSyn21 t21
	| HappyAbsSyn22 t22
	| HappyAbsSyn23 t23
	| HappyAbsSyn24 t24
	| HappyAbsSyn25 t25
	| HappyAbsSyn26 t26
	| HappyAbsSyn27 t27
	| HappyAbsSyn28 t28
	| HappyAbsSyn29 t29
	| HappyAbsSyn30 t30
	| HappyAbsSyn31 t31

action_0 (33) = happyShift action_12
action_0 (37) = happyShift action_13
action_0 (39) = happyShift action_14
action_0 (42) = happyShift action_15
action_0 (45) = happyShift action_16
action_0 (46) = happyShift action_17
action_0 (47) = happyShift action_18
action_0 (48) = happyShift action_19
action_0 (49) = happyShift action_20
action_0 (50) = happyShift action_21
action_0 (53) = happyShift action_22
action_0 (54) = happyShift action_23
action_0 (4) = happyGoto action_24
action_0 (6) = happyGoto action_3
action_0 (7) = happyGoto action_4
action_0 (8) = happyGoto action_5
action_0 (12) = happyGoto action_6
action_0 (14) = happyGoto action_7
action_0 (15) = happyGoto action_8
action_0 (16) = happyGoto action_9
action_0 (17) = happyGoto action_10
action_0 (22) = happyGoto action_11
action_0 _ = happyFail

action_1 (33) = happyShift action_12
action_1 (37) = happyShift action_13
action_1 (39) = happyShift action_14
action_1 (42) = happyShift action_15
action_1 (45) = happyShift action_16
action_1 (46) = happyShift action_17
action_1 (47) = happyShift action_18
action_1 (48) = happyShift action_19
action_1 (49) = happyShift action_20
action_1 (50) = happyShift action_21
action_1 (53) = happyShift action_22
action_1 (54) = happyShift action_23
action_1 (4) = happyGoto action_2
action_1 (6) = happyGoto action_3
action_1 (7) = happyGoto action_4
action_1 (8) = happyGoto action_5
action_1 (12) = happyGoto action_6
action_1 (14) = happyGoto action_7
action_1 (15) = happyGoto action_8
action_1 (16) = happyGoto action_9
action_1 (17) = happyGoto action_10
action_1 (22) = happyGoto action_11
action_1 _ = happyFail

action_2 (43) = happyShift action_25
action_2 _ = happyFail

action_3 (44) = happyShift action_44
action_3 (55) = happyShift action_45
action_3 (56) = happyShift action_46
action_3 (57) = happyShift action_47
action_3 (5) = happyGoto action_40
action_3 (9) = happyGoto action_41
action_3 (13) = happyGoto action_42
action_3 (23) = happyGoto action_43
action_3 _ = happyReduce_2

action_4 _ = happyReduce_47

action_5 (35) = happyShift action_39
action_5 _ = happyReduce_10

action_6 _ = happyReduce_5

action_7 _ = happyReduce_18

action_8 _ = happyReduce_19

action_9 _ = happyReduce_23

action_10 _ = happyReduce_22

action_11 (33) = happyShift action_12
action_11 (37) = happyShift action_13
action_11 (39) = happyShift action_14
action_11 (42) = happyShift action_15
action_11 (45) = happyShift action_16
action_11 (46) = happyShift action_17
action_11 (47) = happyShift action_18
action_11 (48) = happyShift action_19
action_11 (49) = happyShift action_20
action_11 (50) = happyShift action_21
action_11 (53) = happyShift action_22
action_11 (54) = happyShift action_23
action_11 (7) = happyGoto action_38
action_11 (8) = happyGoto action_5
action_11 (14) = happyGoto action_7
action_11 (15) = happyGoto action_8
action_11 (16) = happyGoto action_9
action_11 (17) = happyGoto action_10
action_11 _ = happyReduce_34

action_12 (33) = happyShift action_12
action_12 (37) = happyShift action_13
action_12 (39) = happyShift action_14
action_12 (42) = happyShift action_15
action_12 (45) = happyShift action_16
action_12 (46) = happyShift action_17
action_12 (47) = happyShift action_18
action_12 (48) = happyShift action_19
action_12 (49) = happyShift action_20
action_12 (50) = happyShift action_21
action_12 (51) = happyShift action_34
action_12 (52) = happyShift action_35
action_12 (53) = happyShift action_22
action_12 (54) = happyShift action_23
action_12 (55) = happyShift action_36
action_12 (56) = happyShift action_37
action_12 (4) = happyGoto action_32
action_12 (6) = happyGoto action_3
action_12 (7) = happyGoto action_4
action_12 (8) = happyGoto action_5
action_12 (11) = happyGoto action_33
action_12 (12) = happyGoto action_6
action_12 (14) = happyGoto action_7
action_12 (15) = happyGoto action_8
action_12 (16) = happyGoto action_9
action_12 (17) = happyGoto action_10
action_12 (22) = happyGoto action_11
action_12 _ = happyReduce_32

action_13 (33) = happyShift action_12
action_13 (37) = happyShift action_13
action_13 (39) = happyShift action_14
action_13 (42) = happyShift action_15
action_13 (45) = happyShift action_16
action_13 (46) = happyShift action_17
action_13 (47) = happyShift action_18
action_13 (48) = happyShift action_19
action_13 (49) = happyShift action_20
action_13 (50) = happyShift action_21
action_13 (53) = happyShift action_22
action_13 (54) = happyShift action_23
action_13 (4) = happyGoto action_29
action_13 (6) = happyGoto action_3
action_13 (7) = happyGoto action_4
action_13 (8) = happyGoto action_5
action_13 (12) = happyGoto action_6
action_13 (14) = happyGoto action_7
action_13 (15) = happyGoto action_8
action_13 (16) = happyGoto action_9
action_13 (17) = happyGoto action_10
action_13 (19) = happyGoto action_30
action_13 (20) = happyGoto action_31
action_13 (22) = happyGoto action_11
action_13 _ = happyReduce_43

action_14 (49) = happyShift action_27
action_14 (53) = happyShift action_28
action_14 _ = happyFail

action_15 (33) = happyShift action_12
action_15 (37) = happyShift action_13
action_15 (39) = happyShift action_14
action_15 (42) = happyShift action_15
action_15 (45) = happyShift action_16
action_15 (46) = happyShift action_17
action_15 (47) = happyShift action_18
action_15 (48) = happyShift action_19
action_15 (49) = happyShift action_20
action_15 (50) = happyShift action_21
action_15 (53) = happyShift action_22
action_15 (54) = happyShift action_23
action_15 (7) = happyGoto action_26
action_15 (8) = happyGoto action_5
action_15 (14) = happyGoto action_7
action_15 (15) = happyGoto action_8
action_15 (16) = happyGoto action_9
action_15 (17) = happyGoto action_10
action_15 _ = happyFail

action_16 _ = happyReduce_11

action_17 _ = happyReduce_12

action_18 _ = happyReduce_13

action_19 _ = happyReduce_14

action_20 _ = happyReduce_20

action_21 _ = happyReduce_21

action_22 _ = happyReduce_16

action_23 _ = happyReduce_17

action_24 (43) = happyShift action_25
action_24 (58) = happyAccept
action_24 _ = happyFail

action_25 (33) = happyShift action_12
action_25 (37) = happyShift action_13
action_25 (39) = happyShift action_14
action_25 (42) = happyShift action_15
action_25 (45) = happyShift action_16
action_25 (46) = happyShift action_17
action_25 (47) = happyShift action_18
action_25 (48) = happyShift action_19
action_25 (49) = happyShift action_20
action_25 (50) = happyShift action_21
action_25 (53) = happyShift action_22
action_25 (54) = happyShift action_23
action_25 (6) = happyGoto action_71
action_25 (7) = happyGoto action_4
action_25 (8) = happyGoto action_5
action_25 (12) = happyGoto action_6
action_25 (14) = happyGoto action_7
action_25 (15) = happyGoto action_8
action_25 (16) = happyGoto action_9
action_25 (17) = happyGoto action_10
action_25 (22) = happyGoto action_11
action_25 _ = happyFail

action_26 _ = happyReduce_15

action_27 (40) = happyShift action_70
action_27 _ = happyFail

action_28 (40) = happyShift action_69
action_28 _ = happyFail

action_29 (41) = happyShift action_68
action_29 (43) = happyShift action_25
action_29 (21) = happyGoto action_64
action_29 (25) = happyGoto action_65
action_29 (27) = happyGoto action_66
action_29 (30) = happyGoto action_67
action_29 _ = happyReduce_46

action_30 (38) = happyShift action_63
action_30 _ = happyFail

action_31 _ = happyReduce_42

action_32 (34) = happyShift action_61
action_32 (41) = happyShift action_62
action_32 (43) = happyShift action_25
action_32 _ = happyFail

action_33 (34) = happyShift action_60
action_33 _ = happyFail

action_34 (34) = happyShift action_59
action_34 _ = happyFail

action_35 (34) = happyShift action_58
action_35 _ = happyFail

action_36 (34) = happyShift action_57
action_36 _ = happyFail

action_37 (34) = happyShift action_56
action_37 _ = happyFail

action_38 _ = happyReduce_48

action_39 (49) = happyShift action_55
action_39 (10) = happyGoto action_52
action_39 (18) = happyGoto action_53
action_39 (24) = happyGoto action_54
action_39 _ = happyReduce_41

action_40 _ = happyReduce_49

action_41 (33) = happyShift action_12
action_41 (37) = happyShift action_13
action_41 (39) = happyShift action_14
action_41 (42) = happyShift action_15
action_41 (45) = happyShift action_16
action_41 (46) = happyShift action_17
action_41 (47) = happyShift action_18
action_41 (48) = happyShift action_19
action_41 (49) = happyShift action_20
action_41 (50) = happyShift action_21
action_41 (53) = happyShift action_22
action_41 (54) = happyShift action_23
action_41 (6) = happyGoto action_51
action_41 (7) = happyGoto action_4
action_41 (8) = happyGoto action_5
action_41 (12) = happyGoto action_6
action_41 (14) = happyGoto action_7
action_41 (15) = happyGoto action_8
action_41 (16) = happyGoto action_9
action_41 (17) = happyGoto action_10
action_41 (22) = happyGoto action_11
action_41 _ = happyFail

action_42 _ = happyReduce_3

action_43 (44) = happyShift action_44
action_43 (55) = happyShift action_45
action_43 (56) = happyShift action_46
action_43 (57) = happyShift action_47
action_43 (5) = happyGoto action_50
action_43 (9) = happyGoto action_41
action_43 _ = happyReduce_35

action_44 (53) = happyShift action_48
action_44 (54) = happyShift action_49
action_44 _ = happyFail

action_45 _ = happyReduce_26

action_46 _ = happyReduce_27

action_47 _ = happyReduce_30

action_48 (44) = happyShift action_83
action_48 _ = happyFail

action_49 (44) = happyShift action_82
action_49 _ = happyFail

action_50 _ = happyReduce_50

action_51 _ = happyReduce_4

action_52 (41) = happyShift action_81
action_52 (26) = happyGoto action_77
action_52 (28) = happyGoto action_78
action_52 (29) = happyGoto action_79
action_52 (31) = happyGoto action_80
action_52 _ = happyReduce_54

action_53 (36) = happyShift action_76
action_53 _ = happyFail

action_54 _ = happyReduce_40

action_55 (32) = happyShift action_75
action_55 _ = happyFail

action_56 _ = happyReduce_37

action_57 _ = happyReduce_36

action_58 _ = happyReduce_38

action_59 _ = happyReduce_39

action_60 _ = happyReduce_8

action_61 _ = happyReduce_6

action_62 (33) = happyShift action_12
action_62 (37) = happyShift action_13
action_62 (39) = happyShift action_14
action_62 (42) = happyShift action_15
action_62 (45) = happyShift action_16
action_62 (46) = happyShift action_17
action_62 (47) = happyShift action_18
action_62 (48) = happyShift action_19
action_62 (49) = happyShift action_20
action_62 (50) = happyShift action_21
action_62 (53) = happyShift action_22
action_62 (54) = happyShift action_23
action_62 (4) = happyGoto action_29
action_62 (6) = happyGoto action_3
action_62 (7) = happyGoto action_4
action_62 (8) = happyGoto action_5
action_62 (12) = happyGoto action_6
action_62 (14) = happyGoto action_7
action_62 (15) = happyGoto action_8
action_62 (16) = happyGoto action_9
action_62 (17) = happyGoto action_10
action_62 (20) = happyGoto action_74
action_62 (22) = happyGoto action_11
action_62 _ = happyFail

action_63 _ = happyReduce_7

action_64 _ = happyReduce_44

action_65 _ = happyReduce_58

action_66 _ = happyReduce_45

action_67 (41) = happyShift action_68
action_67 (25) = happyGoto action_73
action_67 _ = happyReduce_55

action_68 (33) = happyShift action_12
action_68 (37) = happyShift action_13
action_68 (39) = happyShift action_14
action_68 (42) = happyShift action_15
action_68 (45) = happyShift action_16
action_68 (46) = happyShift action_17
action_68 (47) = happyShift action_18
action_68 (48) = happyShift action_19
action_68 (49) = happyShift action_20
action_68 (50) = happyShift action_21
action_68 (53) = happyShift action_22
action_68 (54) = happyShift action_23
action_68 (4) = happyGoto action_72
action_68 (6) = happyGoto action_3
action_68 (7) = happyGoto action_4
action_68 (8) = happyGoto action_5
action_68 (12) = happyGoto action_6
action_68 (14) = happyGoto action_7
action_68 (15) = happyGoto action_8
action_68 (16) = happyGoto action_9
action_68 (17) = happyGoto action_10
action_68 (22) = happyGoto action_11
action_68 _ = happyFail

action_69 _ = happyReduce_25

action_70 _ = happyReduce_24

action_71 _ = happyReduce_1

action_72 (43) = happyShift action_25
action_72 _ = happyReduce_52

action_73 _ = happyReduce_59

action_74 _ = happyReduce_33

action_75 (33) = happyShift action_12
action_75 (37) = happyShift action_13
action_75 (39) = happyShift action_14
action_75 (42) = happyShift action_15
action_75 (45) = happyShift action_16
action_75 (46) = happyShift action_17
action_75 (47) = happyShift action_18
action_75 (48) = happyShift action_19
action_75 (49) = happyShift action_20
action_75 (50) = happyShift action_21
action_75 (53) = happyShift action_22
action_75 (54) = happyShift action_23
action_75 (4) = happyGoto action_86
action_75 (6) = happyGoto action_3
action_75 (7) = happyGoto action_4
action_75 (8) = happyGoto action_5
action_75 (12) = happyGoto action_6
action_75 (14) = happyGoto action_7
action_75 (15) = happyGoto action_8
action_75 (16) = happyGoto action_9
action_75 (17) = happyGoto action_10
action_75 (22) = happyGoto action_11
action_75 _ = happyFail

action_76 _ = happyReduce_9

action_77 _ = happyReduce_51

action_78 _ = happyReduce_60

action_79 _ = happyReduce_53

action_80 (41) = happyShift action_81
action_80 (28) = happyGoto action_85
action_80 _ = happyReduce_57

action_81 (49) = happyShift action_55
action_81 (10) = happyGoto action_84
action_81 _ = happyFail

action_82 _ = happyReduce_29

action_83 _ = happyReduce_28

action_84 _ = happyReduce_56

action_85 _ = happyReduce_61

action_86 (43) = happyShift action_25
action_86 _ = happyReduce_31

happyReduce_1 = happySpecReduce_3  4 happyReduction_1
happyReduction_1 (HappyAbsSyn4  happy_var_3)
	_
	(HappyAbsSyn4  happy_var_1)
	 =  HappyAbsSyn4
		 (Ratio happy_var_1 happy_var_3
	)
happyReduction_1 _ _ _  = notHappyAtAll 

happyReduce_2 = happySpecReduce_1  4 happyReduction_2
happyReduction_2 (HappyAbsSyn4  happy_var_1)
	 =  HappyAbsSyn4
		 (happy_var_1
	)
happyReduction_2 _  = notHappyAtAll 

happyReduce_3 = happySpecReduce_2  4 happyReduction_3
happyReduction_3 (HappyAbsSyn13  happy_var_2)
	(HappyAbsSyn4  happy_var_1)
	 =  HappyAbsSyn4
		 (InfixCons happy_var_1 happy_var_2
	)
happyReduction_3 _ _  = notHappyAtAll 

happyReduce_4 = happySpecReduce_2  5 happyReduction_4
happyReduction_4 (HappyAbsSyn4  happy_var_2)
	(HappyAbsSyn8  happy_var_1)
	 =  HappyAbsSyn5
		 ((happy_var_1,happy_var_2)
	)
happyReduction_4 _ _  = notHappyAtAll 

happyReduce_5 = happySpecReduce_1  6 happyReduction_5
happyReduction_5 (HappyAbsSyn12  happy_var_1)
	 =  HappyAbsSyn4
		 (mkValue happy_var_1
	)
happyReduction_5 _  = notHappyAtAll 

happyReduce_6 = happySpecReduce_3  7 happyReduction_6
happyReduction_6 _
	(HappyAbsSyn4  happy_var_2)
	_
	 =  HappyAbsSyn4
		 (happy_var_2
	)
happyReduction_6 _ _ _  = notHappyAtAll 

happyReduce_7 = happySpecReduce_3  7 happyReduction_7
happyReduction_7 _
	(HappyAbsSyn19  happy_var_2)
	_
	 =  HappyAbsSyn4
		 (List happy_var_2
	)
happyReduction_7 _ _ _  = notHappyAtAll 

happyReduce_8 = happySpecReduce_3  7 happyReduction_8
happyReduction_8 _
	(HappyAbsSyn11  happy_var_2)
	_
	 =  HappyAbsSyn4
		 (Tuple happy_var_2
	)
happyReduction_8 _ _ _  = notHappyAtAll 

happyReduce_9 = happyReduce 4 7 happyReduction_9
happyReduction_9 (_ `HappyStk`
	(HappyAbsSyn18  happy_var_3) `HappyStk`
	_ `HappyStk`
	(HappyAbsSyn8  happy_var_1) `HappyStk`
	happyRest)
	 = HappyAbsSyn4
		 (Rec happy_var_1 happy_var_3
	) `HappyStk` happyRest

happyReduce_10 = happySpecReduce_1  7 happyReduction_10
happyReduction_10 (HappyAbsSyn8  happy_var_1)
	 =  HappyAbsSyn4
		 (Con happy_var_1 []
	)
happyReduction_10 _  = notHappyAtAll 

happyReduce_11 = happySpecReduce_1  7 happyReduction_11
happyReduction_11 (HappyTerminal ((IntLit,   (_,happy_var_1))))
	 =  HappyAbsSyn4
		 (Integer happy_var_1
	)
happyReduction_11 _  = notHappyAtAll 

happyReduce_12 = happySpecReduce_1  7 happyReduction_12
happyReduction_12 (HappyTerminal ((FloatLit, (_,happy_var_1))))
	 =  HappyAbsSyn4
		 (Float happy_var_1
	)
happyReduction_12 _  = notHappyAtAll 

happyReduce_13 = happySpecReduce_1  7 happyReduction_13
happyReduction_13 (HappyTerminal ((StringLit, (_,happy_var_1))))
	 =  HappyAbsSyn4
		 (String happy_var_1
	)
happyReduction_13 _  = notHappyAtAll 

happyReduce_14 = happySpecReduce_1  7 happyReduction_14
happyReduction_14 (HappyTerminal ((CharLit,  (_,happy_var_1))))
	 =  HappyAbsSyn4
		 (Char happy_var_1
	)
happyReduction_14 _  = notHappyAtAll 

happyReduce_15 = happySpecReduce_2  7 happyReduction_15
happyReduction_15 (HappyAbsSyn4  happy_var_2)
	_
	 =  HappyAbsSyn4
		 (Neg happy_var_2
	)
happyReduction_15 _ _  = notHappyAtAll 

happyReduce_16 = happySpecReduce_1  8 happyReduction_16
happyReduction_16 (HappyTerminal ((Conid,    (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_16 _  = notHappyAtAll 

happyReduce_17 = happySpecReduce_1  8 happyReduction_17
happyReduction_17 (HappyTerminal ((Qconid,   (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_17 _  = notHappyAtAll 

happyReduce_18 = happySpecReduce_1  8 happyReduction_18
happyReduction_18 (HappyAbsSyn14  happy_var_1)
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_18 _  = notHappyAtAll 

happyReduce_19 = happySpecReduce_1  8 happyReduction_19
happyReduction_19 (HappyAbsSyn15  happy_var_1)
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_19 _  = notHappyAtAll 

happyReduce_20 = happySpecReduce_1  8 happyReduction_20
happyReduction_20 (HappyTerminal ((Varid,    (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_20 _  = notHappyAtAll 

happyReduce_21 = happySpecReduce_1  8 happyReduction_21
happyReduction_21 (HappyTerminal ((Qvarid,   (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_21 _  = notHappyAtAll 

happyReduce_22 = happySpecReduce_1  8 happyReduction_22
happyReduction_22 (HappyAbsSyn17  happy_var_1)
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_22 _  = notHappyAtAll 

happyReduce_23 = happySpecReduce_1  8 happyReduction_23
happyReduction_23 (HappyAbsSyn16  happy_var_1)
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_23 _  = notHappyAtAll 

happyReduce_24 = happySpecReduce_3  8 happyReduction_24
happyReduction_24 _
	_
	(HappyTerminal happy_var_1)
	 =  HappyAbsSyn8
		 ("<" ++ happy_var_1 ++ ">"
	)
happyReduction_24 _ _ _  = notHappyAtAll 

happyReduce_25 = happySpecReduce_3  8 happyReduction_25
happyReduction_25 _
	_
	(HappyTerminal happy_var_1)
	 =  HappyAbsSyn8
		 ("<" ++ happy_var_1 ++ ">"
	)
happyReduction_25 _ _ _  = notHappyAtAll 

happyReduce_26 = happySpecReduce_1  9 happyReduction_26
happyReduction_26 (HappyTerminal ((Consym,   (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_26 _  = notHappyAtAll 

happyReduce_27 = happySpecReduce_1  9 happyReduction_27
happyReduction_27 (HappyTerminal ((Qconsym,  (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_27 _  = notHappyAtAll 

happyReduce_28 = happySpecReduce_3  9 happyReduction_28
happyReduction_28 _
	(HappyTerminal ((Conid,    (_,happy_var_2))))
	_
	 =  HappyAbsSyn8
		 (backtick happy_var_2
	)
happyReduction_28 _ _ _  = notHappyAtAll 

happyReduce_29 = happySpecReduce_3  9 happyReduction_29
happyReduction_29 _
	(HappyTerminal ((Qconid,   (_,happy_var_2))))
	_
	 =  HappyAbsSyn8
		 (backtick happy_var_2
	)
happyReduction_29 _ _ _  = notHappyAtAll 

happyReduce_30 = happySpecReduce_1  9 happyReduction_30
happyReduction_30 (HappyTerminal ((Reservedop, (_,happy_var_1))))
	 =  HappyAbsSyn8
		 (happy_var_1
	)
happyReduction_30 _  = notHappyAtAll 

happyReduce_31 = happySpecReduce_3  10 happyReduction_31
happyReduction_31 (HappyAbsSyn4  happy_var_3)
	_
	(HappyTerminal ((Varid,    (_,happy_var_1))))
	 =  HappyAbsSyn10
		 ((happy_var_1,happy_var_3)
	)
happyReduction_31 _ _ _  = notHappyAtAll 

happyReduce_32 = happySpecReduce_0  11 happyReduction_32
happyReduction_32  =  HappyAbsSyn11
		 ([]
	)

happyReduce_33 = happySpecReduce_3  11 happyReduction_33
happyReduction_33 (HappyAbsSyn20  happy_var_3)
	_
	(HappyAbsSyn4  happy_var_1)
	 =  HappyAbsSyn11
		 (happy_var_1 : happy_var_3
	)
happyReduction_33 _ _ _  = notHappyAtAll 

happyReduce_34 = happySpecReduce_1  12 happyReduction_34
happyReduction_34 (HappyAbsSyn22  happy_var_1)
	 =  HappyAbsSyn12
		 (reverse happy_var_1
	)
happyReduction_34 _  = notHappyAtAll 

happyReduce_35 = happySpecReduce_1  13 happyReduction_35
happyReduction_35 (HappyAbsSyn23  happy_var_1)
	 =  HappyAbsSyn13
		 (reverse happy_var_1
	)
happyReduction_35 _  = notHappyAtAll 

happyReduce_36 = happySpecReduce_3  14 happyReduction_36
happyReduction_36 _
	(HappyTerminal ((Consym,   (_,happy_var_2))))
	_
	 =  HappyAbsSyn14
		 ("(" ++ happy_var_2 ++ ")"
	)
happyReduction_36 _ _ _  = notHappyAtAll 

happyReduce_37 = happySpecReduce_3  15 happyReduction_37
happyReduction_37 _
	(HappyTerminal ((Qconsym,  (_,happy_var_2))))
	_
	 =  HappyAbsSyn15
		 ("(" ++ happy_var_2 ++ ")"
	)
happyReduction_37 _ _ _  = notHappyAtAll 

happyReduce_38 = happySpecReduce_3  16 happyReduction_38
happyReduction_38 _
	(HappyTerminal ((Qvarsym,  (_,happy_var_2))))
	_
	 =  HappyAbsSyn16
		 ("(" ++ happy_var_2 ++ ")"
	)
happyReduction_38 _ _ _  = notHappyAtAll 

happyReduce_39 = happySpecReduce_3  17 happyReduction_39
happyReduction_39 _
	(HappyTerminal ((Varsym,   (_,happy_var_2))))
	_
	 =  HappyAbsSyn17
		 ("(" ++ happy_var_2 ++ ")"
	)
happyReduction_39 _ _ _  = notHappyAtAll 

happyReduce_40 = happySpecReduce_1  18 happyReduction_40
happyReduction_40 (HappyAbsSyn24  happy_var_1)
	 =  HappyAbsSyn18
		 (happy_var_1
	)
happyReduction_40 _  = notHappyAtAll 

happyReduce_41 = happySpecReduce_0  18 happyReduction_41
happyReduction_41  =  HappyAbsSyn18
		 ([]
	)

happyReduce_42 = happySpecReduce_1  19 happyReduction_42
happyReduction_42 (HappyAbsSyn20  happy_var_1)
	 =  HappyAbsSyn19
		 (happy_var_1
	)
happyReduction_42 _  = notHappyAtAll 

happyReduce_43 = happySpecReduce_0  19 happyReduction_43
happyReduction_43  =  HappyAbsSyn19
		 ([]
	)

happyReduce_44 = happySpecReduce_2  20 happyReduction_44
happyReduction_44 (HappyAbsSyn21  happy_var_2)
	(HappyAbsSyn4  happy_var_1)
	 =  HappyAbsSyn20
		 (happy_var_1 : happy_var_2
	)
happyReduction_44 _ _  = notHappyAtAll 

happyReduce_45 = happySpecReduce_1  21 happyReduction_45
happyReduction_45 (HappyAbsSyn27  happy_var_1)
	 =  HappyAbsSyn21
		 (happy_var_1
	)
happyReduction_45 _  = notHappyAtAll 

happyReduce_46 = happySpecReduce_0  21 happyReduction_46
happyReduction_46  =  HappyAbsSyn21
		 ([]
	)

happyReduce_47 = happySpecReduce_1  22 happyReduction_47
happyReduction_47 (HappyAbsSyn4  happy_var_1)
	 =  HappyAbsSyn22
		 ([happy_var_1]
	)
happyReduction_47 _  = notHappyAtAll 

happyReduce_48 = happySpecReduce_2  22 happyReduction_48
happyReduction_48 (HappyAbsSyn4  happy_var_2)
	(HappyAbsSyn22  happy_var_1)
	 =  HappyAbsSyn22
		 (happy_var_2 : happy_var_1
	)
happyReduction_48 _ _  = notHappyAtAll 

happyReduce_49 = happySpecReduce_1  23 happyReduction_49
happyReduction_49 (HappyAbsSyn5  happy_var_1)
	 =  HappyAbsSyn23
		 ([happy_var_1]
	)
happyReduction_49 _  = notHappyAtAll 

happyReduce_50 = happySpecReduce_2  23 happyReduction_50
happyReduction_50 (HappyAbsSyn5  happy_var_2)
	(HappyAbsSyn23  happy_var_1)
	 =  HappyAbsSyn23
		 (happy_var_2 : happy_var_1
	)
happyReduction_50 _ _  = notHappyAtAll 

happyReduce_51 = happySpecReduce_2  24 happyReduction_51
happyReduction_51 (HappyAbsSyn26  happy_var_2)
	(HappyAbsSyn10  happy_var_1)
	 =  HappyAbsSyn24
		 (happy_var_1 : happy_var_2
	)
happyReduction_51 _ _  = notHappyAtAll 

happyReduce_52 = happySpecReduce_2  25 happyReduction_52
happyReduction_52 (HappyAbsSyn4  happy_var_2)
	_
	 =  HappyAbsSyn25
		 (happy_var_2
	)
happyReduction_52 _ _  = notHappyAtAll 

happyReduce_53 = happySpecReduce_1  26 happyReduction_53
happyReduction_53 (HappyAbsSyn29  happy_var_1)
	 =  HappyAbsSyn26
		 (happy_var_1
	)
happyReduction_53 _  = notHappyAtAll 

happyReduce_54 = happySpecReduce_0  26 happyReduction_54
happyReduction_54  =  HappyAbsSyn26
		 ([]
	)

happyReduce_55 = happySpecReduce_1  27 happyReduction_55
happyReduction_55 (HappyAbsSyn30  happy_var_1)
	 =  HappyAbsSyn27
		 (reverse happy_var_1
	)
happyReduction_55 _  = notHappyAtAll 

happyReduce_56 = happySpecReduce_2  28 happyReduction_56
happyReduction_56 (HappyAbsSyn10  happy_var_2)
	_
	 =  HappyAbsSyn28
		 (happy_var_2
	)
happyReduction_56 _ _  = notHappyAtAll 

happyReduce_57 = happySpecReduce_1  29 happyReduction_57
happyReduction_57 (HappyAbsSyn31  happy_var_1)
	 =  HappyAbsSyn29
		 (reverse happy_var_1
	)
happyReduction_57 _  = notHappyAtAll 

happyReduce_58 = happySpecReduce_1  30 happyReduction_58
happyReduction_58 (HappyAbsSyn25  happy_var_1)
	 =  HappyAbsSyn30
		 ([happy_var_1]
	)
happyReduction_58 _  = notHappyAtAll 

happyReduce_59 = happySpecReduce_2  30 happyReduction_59
happyReduction_59 (HappyAbsSyn25  happy_var_2)
	(HappyAbsSyn30  happy_var_1)
	 =  HappyAbsSyn30
		 (happy_var_2 : happy_var_1
	)
happyReduction_59 _ _  = notHappyAtAll 

happyReduce_60 = happySpecReduce_1  31 happyReduction_60
happyReduction_60 (HappyAbsSyn28  happy_var_1)
	 =  HappyAbsSyn31
		 ([happy_var_1]
	)
happyReduction_60 _  = notHappyAtAll 

happyReduce_61 = happySpecReduce_2  31 happyReduction_61
happyReduction_61 (HappyAbsSyn28  happy_var_2)
	(HappyAbsSyn31  happy_var_1)
	 =  HappyAbsSyn31
		 (happy_var_2 : happy_var_1
	)
happyReduction_61 _ _  = notHappyAtAll 

happyNewToken action sts stk [] =
	action 58 58 notHappyAtAll (HappyState action) sts stk []

happyNewToken action sts stk (tk:tks) =
	let cont i = action i i tk (HappyState action) sts stk tks in
	case tk of {
	(Reservedop, (_,"=")) -> cont 32;
	(Special, (_,"(")) -> cont 33;
	(Special, (_,")")) -> cont 34;
	(Special, (_,"{")) -> cont 35;
	(Special, (_,"}")) -> cont 36;
	(Special, (_,"[")) -> cont 37;
	(Special, (_,"]")) -> cont 38;
	(Special, (_,"<")) -> cont 39;
	(Special, (_,">")) -> cont 40;
	(Special, (_,",")) -> cont 41;
	(Varsym,  (_,"-")) -> cont 42;
	(Varsym,  (_,"%")) -> cont 43;
	(Special, (_,"`")) -> cont 44;
	(IntLit,   (_,happy_dollar_dollar)) -> cont 45;
	(FloatLit, (_,happy_dollar_dollar)) -> cont 46;
	(StringLit, (_,happy_dollar_dollar)) -> cont 47;
	(CharLit,  (_,happy_dollar_dollar)) -> cont 48;
	(Varid,    (_,happy_dollar_dollar)) -> cont 49;
	(Qvarid,   (_,happy_dollar_dollar)) -> cont 50;
	(Varsym,   (_,happy_dollar_dollar)) -> cont 51;
	(Qvarsym,  (_,happy_dollar_dollar)) -> cont 52;
	(Conid,    (_,happy_dollar_dollar)) -> cont 53;
	(Qconid,   (_,happy_dollar_dollar)) -> cont 54;
	(Consym,   (_,happy_dollar_dollar)) -> cont 55;
	(Qconsym,  (_,happy_dollar_dollar)) -> cont 56;
	(Reservedop, (_,happy_dollar_dollar)) -> cont 57;
	_ -> happyError' (tk:tks)
	}

happyError_ 58 tk tks = happyError' tks
happyError_ _ tk tks = happyError' (tk:tks)

happyThen :: () => Maybe a -> (a -> Maybe b) -> Maybe b
happyThen = ((>>=))
happyReturn :: () => a -> Maybe a
happyReturn = (return)
happyThen1 m k tks = ((>>=)) m (\a -> k a tks)
happyReturn1 :: () => a -> b -> Maybe a
happyReturn1 = \a tks -> (return) a
happyError' :: () => [(PosToken)] -> Maybe a
happyError' = happyError

parseValue tks = happySomeParser where
  happySomeParser = happyThen (happyParse action_0 tks) (\x -> case x of {HappyAbsSyn4 z -> happyReturn z; _other -> notHappyAtAll })

happySeq = happyDontSeq


backtick :: String -> String
backtick s = "`" ++ s ++ "`"

happyError :: [PosToken] -> Maybe a
happyError ((_,(p,_)) : _) = Nothing -- error ("Parser error at: " ++ show p)
happyError []              = Nothing -- error ("Parser error at EOF")

mkValue :: [Value] -> Value
mkValue [v]             = v
mkValue (Con x [] : vs) = Con x vs
mkValue vs              = Con "" vs
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
{-# LINE 1 "<built-in>" #-}
{-# LINE 1 "<command-line>" #-}
{-# LINE 8 "<command-line>" #-}
# 1 "/usr/include/stdc-predef.h" 1 3 4

# 17 "/usr/include/stdc-predef.h" 3 4











































{-# LINE 8 "<command-line>" #-}
{-# LINE 1 "/home/diatchki/tools/ghc-8.0.1/lib/ghc-8.0.1/include/ghcversion.h" #-}

















{-# LINE 8 "<command-line>" #-}
{-# LINE 1 "/tmp/ghc17608_0/ghc_2.h" #-}




















































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































































{-# LINE 8 "<command-line>" #-}
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- Id: GenericTemplate.hs,v 1.26 2005/01/14 14:47:22 simonmar Exp 

{-# LINE 13 "templates/GenericTemplate.hs" #-}

{-# LINE 46 "templates/GenericTemplate.hs" #-}








{-# LINE 67 "templates/GenericTemplate.hs" #-}

{-# LINE 77 "templates/GenericTemplate.hs" #-}

{-# LINE 86 "templates/GenericTemplate.hs" #-}

infixr 9 `HappyStk`
data HappyStk a = HappyStk a (HappyStk a)

-----------------------------------------------------------------------------
-- starting the parse

happyParse start_state = happyNewToken start_state notHappyAtAll notHappyAtAll

-----------------------------------------------------------------------------
-- Accepting the parse

-- If the current token is (1), it means we've just accepted a partial
-- parse (a %partial parser).  We must ignore the saved token on the top of
-- the stack in this case.
happyAccept (1) tk st sts (_ `HappyStk` ans `HappyStk` _) =
        happyReturn1 ans
happyAccept j tk st sts (HappyStk ans _) = 
         (happyReturn1 ans)

-----------------------------------------------------------------------------
-- Arrays only: do the next action

{-# LINE 155 "templates/GenericTemplate.hs" #-}

-----------------------------------------------------------------------------
-- HappyState data type (not arrays)



newtype HappyState b c = HappyState
        (Int ->                    -- token number
         Int ->                    -- token number (yes, again)
         b ->                           -- token semantic value
         HappyState b c ->              -- current state
         [HappyState b c] ->            -- state stack
         c)



-----------------------------------------------------------------------------
-- Shifting a token

happyShift new_state (1) tk st sts stk@(x `HappyStk` _) =
     let i = (case x of { HappyErrorToken (i) -> i }) in
--     trace "shifting the error token" $
     new_state i i tk (HappyState (new_state)) ((st):(sts)) (stk)

happyShift new_state i tk st sts stk =
     happyNewToken new_state ((st):(sts)) ((HappyTerminal (tk))`HappyStk`stk)

-- happyReduce is specialised for the common cases.

happySpecReduce_0 i fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happySpecReduce_0 nt fn j tk st@((HappyState (action))) sts stk
     = action nt j tk st ((st):(sts)) (fn `HappyStk` stk)

happySpecReduce_1 i fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happySpecReduce_1 nt fn j tk _ sts@(((st@(HappyState (action))):(_))) (v1`HappyStk`stk')
     = let r = fn v1 in
       happySeq r (action nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_2 i fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happySpecReduce_2 nt fn j tk _ ((_):(sts@(((st@(HappyState (action))):(_))))) (v1`HappyStk`v2`HappyStk`stk')
     = let r = fn v1 v2 in
       happySeq r (action nt j tk st sts (r `HappyStk` stk'))

happySpecReduce_3 i fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happySpecReduce_3 nt fn j tk _ ((_):(((_):(sts@(((st@(HappyState (action))):(_))))))) (v1`HappyStk`v2`HappyStk`v3`HappyStk`stk')
     = let r = fn v1 v2 v3 in
       happySeq r (action nt j tk st sts (r `HappyStk` stk'))

happyReduce k i fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happyReduce k nt fn j tk st sts stk
     = case happyDrop (k - ((1) :: Int)) sts of
         sts1@(((st1@(HappyState (action))):(_))) ->
                let r = fn stk in  -- it doesn't hurt to always seq here...
                happyDoSeq r (action nt j tk st1 sts1 r)

happyMonadReduce k nt fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happyMonadReduce k nt fn j tk st sts stk =
      case happyDrop k ((st):(sts)) of
        sts1@(((st1@(HappyState (action))):(_))) ->
          let drop_stk = happyDropStk k stk in
          happyThen1 (fn stk tk) (\r -> action nt j tk st1 sts1 (r `HappyStk` drop_stk))

happyMonad2Reduce k nt fn (1) tk st sts stk
     = happyFail (1) tk st sts stk
happyMonad2Reduce k nt fn j tk st sts stk =
      case happyDrop k ((st):(sts)) of
        sts1@(((st1@(HappyState (action))):(_))) ->
         let drop_stk = happyDropStk k stk





             new_state = action

          in
          happyThen1 (fn stk tk) (\r -> happyNewToken new_state sts1 (r `HappyStk` drop_stk))

happyDrop (0) l = l
happyDrop n ((_):(t)) = happyDrop (n - ((1) :: Int)) t

happyDropStk (0) l = l
happyDropStk n (x `HappyStk` xs) = happyDropStk (n - ((1)::Int)) xs

-----------------------------------------------------------------------------
-- Moving to a new state after a reduction

{-# LINE 256 "templates/GenericTemplate.hs" #-}
happyGoto action j tk st = action j j tk (HappyState action)


-----------------------------------------------------------------------------
-- Error recovery ((1) is the error token)

-- parse error if we are in recovery and we fail again
happyFail (1) tk old_st _ stk@(x `HappyStk` _) =
     let i = (case x of { HappyErrorToken (i) -> i }) in
--      trace "failing" $ 
        happyError_ i tk

{-  We don't need state discarding for our restricted implementation of
    "error".  In fact, it can cause some bogus parses, so I've disabled it
    for now --SDM

-- discard a state
happyFail  (1) tk old_st (((HappyState (action))):(sts)) 
                                                (saved_tok `HappyStk` _ `HappyStk` stk) =
--      trace ("discarding state, depth " ++ show (length stk))  $
        action (1) (1) tk (HappyState (action)) sts ((saved_tok`HappyStk`stk))
-}

-- Enter error recovery: generate an error token,
--                       save the old token and carry on.
happyFail  i tk (HappyState (action)) sts stk =
--      trace "entering error recovery" $
        action (1) (1) tk (HappyState (action)) sts ( (HappyErrorToken (i)) `HappyStk` stk)

-- Internal happy errors:

notHappyAtAll :: a
notHappyAtAll = error "Internal Happy error\n"

-----------------------------------------------------------------------------
-- Hack to get the typechecker to accept our action functions







-----------------------------------------------------------------------------
-- Seq-ing.  If the --strict flag is given, then Happy emits 
--      happySeq = happyDoSeq
-- otherwise it emits
--      happySeq = happyDontSeq

happyDoSeq, happyDontSeq :: a -> b -> b
happyDoSeq   a b = a `seq` b
happyDontSeq a b = b

-----------------------------------------------------------------------------
-- Don't inline any functions from the template.  GHC has a nasty habit
-- of deciding to inline happyGoto everywhere, which increases the size of
-- the generated parser quite a bit.

{-# LINE 322 "templates/GenericTemplate.hs" #-}
{-# NOINLINE happyShift #-}
{-# NOINLINE happySpecReduce_0 #-}
{-# NOINLINE happySpecReduce_1 #-}
{-# NOINLINE happySpecReduce_2 #-}
{-# NOINLINE happySpecReduce_3 #-}
{-# NOINLINE happyReduce #-}
{-# NOINLINE happyMonadReduce #-}
{-# NOINLINE happyGoto #-}
{-# NOINLINE happyFail #-}

-- end of Happy Template.
