# Oracle VirtualBox

VirtualBox is a general-purpose full virtualization software for x86_64
hardware (with version 7.1 additionally for macOS/Arm), targeted at laptop,
desktop, server and embedded use.

It features a very user friendly graphical user interface and is available for
many popular operating systems (Linux, Windows, macOS and Solaris). Flexible
networking setup and interactive performance are the strong points.

Anyone with the need to run multiple operating systems simultaneously with some
basic knowledge about PCs and operating system installation can use it to
reduce effort with a large number of tasks including software testing.

## Getting started

VirtualBox is a complex product with multiple dependencies, some of them
specific to the operating system on which you want to run it.

The basics for building VirtualBox are described on the [build
instructions](https://www.virtualbox.org/wiki/Build_instructions) page. 

## Documentation

The [VirtualBox User
Guide](https://docs.oracle.com/en/virtualization/virtualbox/index.html)
contains all information relevant for users, including the product features and
their configuration.

For developers it is recommended to start with the [technical
documentation](https://www.virtualbox.org/wiki/Technical_documentation) which
contains links to a broad collection of pages related to development, covering
many aspects of the project and its features.

## Examples

Tutorials on how to install and use Oracle VirtualBox are available at
[Learn to Install Oracle VirtualBox and Run Virtual Machines](https://blogs.oracle.com/linux/post/learn-to-install-oracle-virtualbox-and-run-virtual-machines)
and [Use Oracle VirtualBox on Oracle Linux](https://docs.oracle.com/en/learn/ol-vbox/index.html).

## Help

Oracle customers with a support contract covering Oracle VirtualBox should
reach out to [Oracle Support](https://www.oracle.com/support/).

Everyone can use the [VirtualBox Forums](https://forums.virtualbox.org/)
for questions about the product or discussing its functionality. Open an [issue](https://github.com/VirtualBox/virtualbox/issues)
for bug reports or request for enhancements. Report a security vulnerability
according to the [Reporting Vulnerabilities Guide](https://www.oracle.com/corporate/security-practices/assurance/vulnerability/reporting.html).

## Contributing

This project welcomes contributions from the community. Before submitting a
pull request, please [review our contribution guide](./CONTRIBUTING.md)

## Security

Please consult the [security guide](./SECURITY.md) for our responsible security vulnerability disclosure process.

## License

The correct copyright notice format for both documentation and software is

    Copyright (C) [year-]year Oracle and/or its affiliates.
    
    This file is part of VirtualBox base platform packages, as
    available from https://www.virtualbox.org.
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation, in version 3 of the
    License.
   
    This program is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, see <https://www.gnu.org/licenses>.

You must include the year the content was first released (on any platform) and
the most recent year in which it was revised:

    Copyright (C) 2025 Oracle and/or its affiliates.

Released under the GNU General Public License v3.0 as shown at
[COPYING](./COPYING) which contains clarifications regarding allowed licenses
for other code using parts of the project which are covered by multiple
licenses.

