// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk_sys;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib_sys;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;
use Display;

glib_wrapper! {
    pub struct DisplayManager(Object<gdk_sys::GdkDisplayManager, DisplayManagerClass>);

    match fn {
        get_type => || gdk_sys::gdk_display_manager_get_type(),
    }
}

impl DisplayManager {
    pub fn get_default_display(&self) -> Option<Display> {
        unsafe {
            from_glib_none(gdk_sys::gdk_display_manager_get_default_display(
                self.to_glib_none().0,
            ))
        }
    }

    pub fn list_displays(&self) -> Vec<Display> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(gdk_sys::gdk_display_manager_list_displays(
                self.to_glib_none().0,
            ))
        }
    }

    pub fn open_display(&self, name: &str) -> Option<Display> {
        unsafe {
            from_glib_none(gdk_sys::gdk_display_manager_open_display(
                self.to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    pub fn set_default_display(&self, display: &Display) {
        unsafe {
            gdk_sys::gdk_display_manager_set_default_display(
                self.to_glib_none().0,
                display.to_glib_none().0,
            );
        }
    }

    pub fn get() -> DisplayManager {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(gdk_sys::gdk_display_manager_get()) }
    }

    pub fn connect_display_opened<F: Fn(&DisplayManager, &Display) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn display_opened_trampoline<
            F: Fn(&DisplayManager, &Display) + 'static,
        >(
            this: *mut gdk_sys::GdkDisplayManager,
            display: *mut gdk_sys::GdkDisplay,
            f: glib_sys::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(display))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"display-opened\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    display_opened_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    pub fn connect_property_default_display_notify<F: Fn(&DisplayManager) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_default_display_trampoline<F: Fn(&DisplayManager) + 'static>(
            this: *mut gdk_sys::GdkDisplayManager,
            _param_spec: glib_sys::gpointer,
            f: glib_sys::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::default-display\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_default_display_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for DisplayManager {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "DisplayManager")
    }
}
