/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class ArrowField
implements XmlSerializable<ArrowField> {
    private String type;
    private String name;
    private Integer precision;
    private Integer scale;

    public String getType() {
        return this.type;
    }

    public ArrowField setType(String type) {
        this.type = type;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public ArrowField setName(String name) {
        this.name = name;
        return this;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public ArrowField setPrecision(Integer precision) {
        this.precision = precision;
        return this;
    }

    public Integer getScale() {
        return this.scale;
    }

    public ArrowField setScale(Integer scale) {
        this.scale = scale;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Field" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Type", this.type);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeNumberElement("Precision", (Number)this.precision);
        xmlWriter.writeNumberElement("Scale", (Number)this.scale);
        return xmlWriter.writeEndElement();
    }

    public static ArrowField fromXml(XmlReader xmlReader) throws XMLStreamException {
        return ArrowField.fromXml(xmlReader, null);
    }

    public static ArrowField fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Field" : rootElementName;
        return (ArrowField)xmlReader.readObject(finalRootElementName, reader -> {
            ArrowField deserializedArrowField = new ArrowField();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Type".equals(elementName.getLocalPart())) {
                    deserializedArrowField.type = reader.getStringElement();
                    continue;
                }
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedArrowField.name = reader.getStringElement();
                    continue;
                }
                if ("Precision".equals(elementName.getLocalPart())) {
                    deserializedArrowField.precision = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                if ("Scale".equals(elementName.getLocalPart())) {
                    deserializedArrowField.scale = (Integer)reader.getNullableElement(Integer::parseInt);
                    continue;
                }
                reader.skipElement();
            }
            return deserializedArrowField;
        });
    }
}

