/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.planargraph;

import org.locationtech.jts.planargraph.DirectedEdge;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;

public class Edge
extends GraphComponent {
    protected DirectedEdge[] dirEdge;

    public Edge() {
    }

    public Edge(DirectedEdge de0, DirectedEdge de1) {
        this.setDirectedEdges(de0, de1);
    }

    public void setDirectedEdges(DirectedEdge de0, DirectedEdge de1) {
        this.dirEdge = new DirectedEdge[]{de0, de1};
        de0.setEdge(this);
        de1.setEdge(this);
        de0.setSym(de1);
        de1.setSym(de0);
        de0.getFromNode().addOutEdge(de0);
        de1.getFromNode().addOutEdge(de1);
    }

    public DirectedEdge getDirEdge(int i) {
        return this.dirEdge[i];
    }

    public DirectedEdge getDirEdge(Node fromNode) {
        if (this.dirEdge[0].getFromNode() == fromNode) {
            return this.dirEdge[0];
        }
        if (this.dirEdge[1].getFromNode() == fromNode) {
            return this.dirEdge[1];
        }
        return null;
    }

    public Node getOppositeNode(Node node) {
        if (this.dirEdge[0].getFromNode() == node) {
            return this.dirEdge[0].getToNode();
        }
        if (this.dirEdge[1].getFromNode() == node) {
            return this.dirEdge[1].getToNode();
        }
        return null;
    }

    void remove() {
        this.dirEdge = null;
    }

    public boolean isRemoved() {
        return this.dirEdge == null;
    }
}

