/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.DelegationFilter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/JvmDelegationFilter;", "Lorg/jetbrains/kotlin/resolve/lazy/DelegationFilter;", "<init>", "()V", "filter", "", "interfaceMember", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isJavaDefaultMethod", "isBuiltInMemberMappedToJavaDefault", "frontend.java"})
public final class JvmDelegationFilter
implements DelegationFilter {
    @NotNull
    public static final JvmDelegationFilter INSTANCE = new JvmDelegationFilter();

    private JvmDelegationFilter() {
    }

    public boolean filter(@NotNull CallableMemberDescriptor interfaceMember, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)interfaceMember, (String)"interfaceMember");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.NoDelegationToJavaDefaultInterfaceMembers)) {
            return true;
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.unwrapFakeOverride(interfaceMember);
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"unwrapFakeOverride(...)");
        CallableMemberDescriptor realMember = callableMemberDescriptor;
        return !this.isJavaDefaultMethod(realMember) && !JvmAnnotationUtilKt.hasJvmDefaultAnnotation(realMember) && !this.isBuiltInMemberMappedToJavaDefault(realMember);
    }

    private final boolean isJavaDefaultMethod(CallableMemberDescriptor interfaceMember) {
        return interfaceMember instanceof JavaMethodDescriptor && ((JavaMethodDescriptor)interfaceMember).getModality() != Modality.ABSTRACT;
    }

    private final boolean isBuiltInMemberMappedToJavaDefault(CallableMemberDescriptor interfaceMember) {
        return interfaceMember.getModality() != Modality.ABSTRACT && KotlinBuiltIns.isBuiltIn(interfaceMember) && interfaceMember.getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME());
    }
}

