/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.FileResponses;
import org.jetbrains.io.Responses;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "Lorg/jetbrains/ide/HttpRequestHandler;", "<init>", "()V", "defaultResourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$DefaultResourceProvider;", "resourceProviders", "Ljava/util/HashMap;", "", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "Lkotlin/collections/HashMap;", "registerResourceProvider", "Lcom/intellij/openapi/Disposable;", "resourceProvider", "unregisterResourceProvider", "", "getProviderHash", "path", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "getStaticPath", "obtainResourceProvider", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "context", "Lio/netty/channel/ChannelHandlerContext;", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nPreviewStaticServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewStaticServer.kt\norg/intellij/plugins/markdown/ui/preview/PreviewStaticServer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class PreviewStaticServer
extends HttpRequestHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceProvider.DefaultResourceProvider defaultResourceProvider = new ResourceProvider.DefaultResourceProvider();
    @NotNull
    private final HashMap<Integer, ResourceProvider> resourceProviders;
    @NotNull
    private static final String endpointPrefix = "markdownPreview";
    @NotNull
    private static final String prefixPath = "/markdownPreview";
    @NotNull
    private static final String[] typesForExplicitUtfCharset;

    public PreviewStaticServer() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)this.defaultResourceProvider.hashCode(), (Object)this.defaultResourceProvider)};
        this.resourceProviders = MapsKt.hashMapOf((Pair[])pairArray);
    }

    @NotNull
    public final synchronized Disposable registerResourceProvider(@NotNull ResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        ((Map)this.resourceProviders).put(resourceProvider.hashCode(), resourceProvider);
        return () -> PreviewStaticServer.registerResourceProvider$lambda$0(this, resourceProvider);
    }

    public final synchronized void unregisterResourceProvider(@NotNull ResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        this.resourceProviders.remove(resourceProvider.hashCode());
    }

    private final Integer getProviderHash(String path) {
        char[] cArray = new char[]{'/'};
        String string = (String)CollectionsKt.getOrNull((List)StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)2);
        return string != null ? StringsKt.toIntOrNull((String)string) : null;
    }

    private final String getStaticPath(String path) {
        char[] cArray = new char[]{'/'};
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)StringsKt.split$default((CharSequence)path, (char[])cArray, (boolean)false, (int)0, (int)6, null), (int)3), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResourceProvider obtainResourceProvider(String path) {
        ResourceProvider resourceProvider;
        Integer n = this.getProviderHash(path);
        if (n == null) {
            return null;
        }
        int providerHash = n;
        HashMap<Integer, ResourceProvider> hashMap = this.resourceProviders;
        synchronized (hashMap) {
            boolean bl = false;
            resourceProvider = ((Map)this.resourceProviders).getOrDefault(providerHash, null);
        }
        return resourceProvider;
    }

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!super.isSupported(request)) {
            return false;
        }
        String path = request.uri();
        Intrinsics.checkNotNull((Object)path);
        return StringsKt.startsWith$default((String)path, (String)prefixPath, (boolean)false, (int)2, null);
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String path = urlDecoder.path();
        Intrinsics.checkNotNull((Object)path);
        if (!StringsKt.startsWith$default((String)path, (String)prefixPath, (boolean)false, (int)2, null)) {
            boolean $i$a$-check-PreviewStaticServer$process$22 = false;
            String $i$a$-check-PreviewStaticServer$process$22 = "prefix should have been checked by #isSupported";
            throw new IllegalStateException($i$a$-check-PreviewStaticServer$process$22.toString());
        }
        ResourceProvider resourceProvider = this.obtainResourceProvider(path);
        if (resourceProvider == null) {
            return false;
        }
        ResourceProvider resourceProvider2 = resourceProvider;
        String resourceName = this.getStaticPath(path);
        if (resourceProvider2.canProvide(resourceName)) {
            HttpRequest httpRequest = (HttpRequest)request;
            Channel channel = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            PreviewStaticServer.Companion.sendResource(httpRequest, channel, resourceProvider2.loadResource(resourceName), resourceName);
            return true;
        }
        return false;
    }

    private static final void registerResourceProvider$lambda$0(PreviewStaticServer this$0, ResourceProvider $resourceProvider) {
        this$0.unregisterResourceProvider($resourceProvider);
    }

    @NotNull
    public static final PreviewStaticServer getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
        return Companion.createCSP(scripts, styles);
    }

    @JvmStatic
    @NotNull
    public static final String getStaticUrl(@NotNull ResourceProvider resourceProvider, @NotNull String staticPath) {
        return Companion.getStaticUrl(resourceProvider, staticPath);
    }

    static {
        String[] stringArray = new String[]{"application/javascript", "text/html", "text/css", "image/svg+xml"};
        typesForExplicitUtfCharset = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0007J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J*\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer$Companion;", "", "<init>", "()V", "endpointPrefix", "", "prefixPath", "instance", "Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "getInstance$annotations", "getInstance", "()Lorg/intellij/plugins/markdown/ui/preview/PreviewStaticServer;", "createCSP", "scripts", "", "styles", "getStaticUrl", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "staticPath", "typesForExplicitUtfCharset", "", "[Ljava/lang/String;", "guessContentType", "resourceName", "sendResource", "", "request", "Lio/netty/handler/codec/http/HttpRequest;", "channel", "Lio/netty/channel/Channel;", "resource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nPreviewStaticServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewStaticServer.kt\norg/intellij/plugins/markdown/ui/preview/PreviewStaticServer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1563#2:166\n1634#2,3:167\n1563#2:170\n1634#2,3:171\n1#3:174\n*S KotlinDebug\n*F\n+ 1 PreviewStaticServer.kt\norg/intellij/plugins/markdown/ui/preview/PreviewStaticServer$Companion\n*L\n96#1:166\n96#1:167,3\n97#1:170\n97#1:171,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PreviewStaticServer getInstance() {
            PreviewStaticServer previewStaticServer = (PreviewStaticServer)((Object)HttpRequestHandler.Companion.getEP_NAME().findExtension(PreviewStaticServer.class));
            if (previewStaticServer == null) {
                throw new IllegalStateException("Could not get server instance!".toString());
            }
            return previewStaticServer;
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @JvmStatic
        @NotNull
        public final String createCSP(@NotNull List<String> scripts, @NotNull List<String> styles) {
            String p0;
            Object object;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(scripts, (String)"scripts");
            Intrinsics.checkNotNullParameter(styles, (String)"styles");
            Iterable $this$map$iv = scripts;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string = (String)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(org.intellij.plugins.markdown.ui.preview.PreviewStaticServer$Companion.createCSP$stripQueryParameters(p0));
            }
            $this$map$iv = styles;
            object = StringUtil.join((Collection)((List)destination$iv$iv), (String)" ");
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                p0 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(org.intellij.plugins.markdown.ui.preview.PreviewStaticServer$Companion.createCSP$stripQueryParameters(p0));
            }
            return "\n        default-src 'none';\n        script-src " + (String)object + ";\n        style-src https: " + StringUtil.join((Collection)((List)destination$iv$iv), (String)" ") + " 'unsafe-inline';\n        img-src file: * data:; connect-src 'none'; font-src * data: *;\n        object-src 'none'; media-src 'none'; child-src 'none';\n      ";
        }

        @JvmStatic
        @NotNull
        public final String getStaticUrl(@NotNull ResourceProvider resourceProvider, @NotNull String staticPath) {
            Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
            Intrinsics.checkNotNullParameter((Object)staticPath, (String)"staticPath");
            int providerHash = resourceProvider.hashCode();
            int port = BuiltInServerManager.Companion.getInstance().getPort();
            String raw = "http://localhost:" + port + "/markdownPreview/" + providerHash + "/" + staticPath;
            Url url = Urls.parseEncoded((String)raw);
            if (url == null) {
                boolean bl = false;
                String string = "Could not parse url!";
                throw new IllegalArgumentException(string.toString());
            }
            String string = BuiltInServerManager.Companion.getInstance().addAuthToken(url).toExternalForm();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toExternalForm(...)");
            return string;
        }

        private final String guessContentType(String resourceName) {
            String type = FileResponses.INSTANCE.getContentType(resourceName);
            return ArraysKt.contains((Object[])typesForExplicitUtfCharset, (Object)type) ? type + "; charset=utf-8" : type;
        }

        private final void sendResource(HttpRequest request, Channel channel, ResourceProvider.Resource resource2, String resourceName) {
            DefaultFullHttpResponse response;
            long lastModified = ApplicationInfo.getInstance().getBuildDate().getTimeInMillis();
            if (FileResponses.checkCache$default((FileResponses)FileResponses.INSTANCE, (HttpRequest)request, (Channel)channel, (long)lastModified, null, (int)8, null)) {
                return;
            }
            if (resource2 == null) {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                Responses.send$default((HttpResponseStatus)httpResponseStatus, (Channel)channel, (HttpRequest)request, null, null, (int)12, null);
                return;
            }
            DefaultFullHttpResponse $this$sendResource_u24lambda_u242 = response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])resource2.getContent()));
            boolean bl = false;
            HttpHeaders httpHeaders = $this$sendResource_u24lambda_u242.headers();
            CharSequence charSequence = (CharSequence)HttpHeaderNames.CONTENT_TYPE;
            String type = resource2.getType();
            String string = type;
            if (string == null) {
                string = Companion.guessContentType(resourceName);
            }
            httpHeaders.set(charSequence, (Object)string);
            $this$sendResource_u24lambda_u242.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
            $this$sendResource_u24lambda_u242.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)new Date(lastModified));
            Responses.send$default((HttpResponse)((HttpResponse)$this$sendResource_u24lambda_u242), (Channel)channel, (HttpRequest)request, null, (int)4, null);
        }

        private static final String createCSP$stripQueryParameters(String url) {
            return StringsKt.replace$default((String)url, (String)("?" + new URL(url).getQuery()), (String)"", (boolean)false, (int)4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

