/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model;

import com.jetbrains.ml.tools.model.ModelDistributionReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/ml/tools/model/ModelDistributionReaders;", "", "()V", "FromDirectory", "FromJavaResources", "ml-tools"})
public abstract class ModelDistributionReaders {

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/ml/tools/model/ModelDistributionReaders$FromDirectory;", "Lcom/jetbrains/ml/tools/model/ModelDistributionReader;", "rootPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "openStream", "Ljava/io/InputStream;", "relativePath", "ml-tools"})
    public static final class FromDirectory
    implements ModelDistributionReader {
        @NotNull
        private final Path rootPath;

        public FromDirectory(@NotNull Path rootPath) {
            Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
            this.rootPath = rootPath;
        }

        @Override
        @NotNull
        public InputStream openStream(@NotNull Path relativePath) {
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            Path path = this.rootPath.resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(this, *options)");
            return inputStream;
        }

        @Override
        @NotNull
        public String readFile(@NotNull Path relativePath) {
            return ModelDistributionReader.DefaultImpls.readFile(this, relativePath);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/ml/tools/model/ModelDistributionReaders$FromJavaResources;", "Lcom/jetbrains/ml/tools/model/ModelDistributionReader;", "holder", "Ljava/lang/Class;", "root", "Ljava/nio/file/Path;", "(Ljava/lang/Class;Ljava/nio/file/Path;)V", "openStream", "Ljava/io/InputStream;", "relativePath", "ml-tools"})
    public static final class FromJavaResources
    implements ModelDistributionReader {
        @NotNull
        private final Class<?> holder;
        @NotNull
        private final Path root;

        public FromJavaResources(@NotNull Class<?> holder, @NotNull Path root) {
            Intrinsics.checkNotNullParameter(holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.holder = holder;
            this.root = root;
        }

        @Override
        @NotNull
        public InputStream openStream(@NotNull Path relativePath) {
            InputStream fileStream;
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            ClassLoader classLoader = this.holder.getClassLoader();
            Path path = this.root.resolve(relativePath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"this.resolve(other)");
            InputStream inputStream = fileStream = classLoader.getResourceAsStream(CollectionsKt.joinToString$default((Iterable)path, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
            if (inputStream == null) {
                Path path2 = this.root.resolve(relativePath);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"this.resolve(other)");
                throw new FileNotFoundException("File stream not found: " + path2 + ". Resources holder: " + this.holder.getName());
            }
            return inputStream;
        }

        @Override
        @NotNull
        public String readFile(@NotNull Path relativePath) {
            return ModelDistributionReader.DefaultImpls.readFile(this, relativePath);
        }
    }
}

